/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMThreadLocalPointer;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRootNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMAccessThreadLocalSymbolNode
extends LLVMAccessSymbolNode {
    LLVMAccessThreadLocalSymbolNode(LLVMSymbol symbol) {
        super(symbol);
    }

    @Specialization(guards={"isSingleContext($node)"})
    @GenerateAOT.Exclude
    public LLVMPointer accessSingleContext(@Cached BranchProfile exception) throws LLVMIllegalSymbolIndexException {
        LLVMPointer pointer = this.checkNull(this.getContext().getSymbol(this.symbol, exception), exception);
        LLVMThreadLocalPointer threadLocalPointer = (LLVMThreadLocalPointer)LLVMManagedPointer.cast(pointer).getObject();
        return threadLocalPointer.resolve(LLVMLanguage.get(this), exception);
    }

    protected LLVMStack.LLVMStackAccessHolder createStackAccessHolder() {
        return new LLVMStack.LLVMStackAccessHolder(((LLVMRootNode)this.getRootNode()).getStackAccess());
    }

    @Specialization
    public LLVMPointer accessMultiContext(VirtualFrame frame, @Cached(value="createStackAccessHolder()") LLVMStack.LLVMStackAccessHolder stackAccessHolder, @Cached BranchProfile exception) throws LLVMIllegalSymbolIndexException {
        LLVMPointer pointer = this.checkNull(stackAccessHolder.stackAccess.executeGetStack(frame).getContext().getSymbol(this.symbol, exception), exception);
        LLVMThreadLocalPointer threadLocalPointer = (LLVMThreadLocalPointer)LLVMManagedPointer.cast(pointer).getObject();
        return threadLocalPointer.resolve(LLVMLanguage.get(this), exception);
    }
}

