/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMVarArgCompoundValue;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStructStoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeField(type=long.class, name="structSize")
public abstract class LLVMStructStoreNode
extends LLVMStoreNode {
    protected final boolean isRecursive;
    @Node.Child
    private LLVMMemMoveNode memMove;

    @Idempotent
    public abstract long getStructSize();

    protected LLVMStructStoreNode(LLVMMemMoveNode memMove, boolean isRecursive) {
        this.memMove = memMove;
        this.isRecursive = isRecursive;
    }

    protected LLVMStructStoreNode(LLVMMemMoveNode memMove) {
        this(memMove, false);
    }

    protected LLVMStructStoreNode() {
        this(false);
    }

    protected LLVMStructStoreNode(boolean isRecursive) {
        this(null, isRecursive);
    }

    public LLVMStructStoreNode createRecursive() {
        return LLVMStructStoreNodeGen.create((LLVMMemMoveNode)((Node)this.memMove).deepCopy(), null, null, this.getStructSize());
    }

    @Specialization(guards={"getStructSize() == 0"})
    protected void noCopy(Object address, Object value) {
    }

    @Specialization(guards={"getStructSize() > 0", "!isAutoDerefHandle(address)", "!isAutoDerefHandle(value)"})
    protected void doOp(VirtualFrame frame, LLVMNativePointer address, LLVMNativePointer value) {
        this.memMove.executeWithTarget(frame, address, value, this.getStructSize());
    }

    @Specialization(guards={"getStructSize() > 0", "isAutoDerefHandle(addr)", "isAutoDerefHandle(value)"})
    protected void doOpDerefHandle(VirtualFrame frame, LLVMNativePointer addr, LLVMNativePointer value, @Cached LLVMDerefHandleGetReceiverNode getReceiver) {
        this.doManaged(frame, getReceiver.execute(addr), getReceiver.execute(value));
    }

    @Specialization(guards={"getStructSize() > 0"})
    protected void doManaged(VirtualFrame frame, LLVMManagedPointer address, LLVMPointer value) {
        this.memMove.executeWithTarget(frame, address, value, this.getStructSize());
    }

    @Specialization(guards={"getStructSize() > 0", "!isAutoDerefHandle(address)"}, replaces={"doOp"})
    protected void doConvert(VirtualFrame frame, LLVMNativePointer address, LLVMPointer value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative) {
        this.memMove.executeWithTarget(frame, address, toNative.executeWithTarget(value), this.getStructSize());
    }

    @Specialization(guards={"!isRecursive"})
    protected void doVarArgCompoundValue(VirtualFrame frame, LLVMNativePointer address, LLVMVarArgCompoundValue value, @Cached(value="createRecursive()") LLVMStructStoreNode recursionNode) {
        recursionNode.executeWithTarget(frame, address, value.getAddr());
    }
}

