/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.aarch64.linux.LLVMLinuxAarch64VaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListStorageFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.ManagedMemMoveHelperNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.ManagedMemMoveHelperNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.NativeProfiledMemMoveToNative;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GenerateUncached
public abstract class NativeProfiledMemMove
extends LLVMNode
implements LLVMMemMoveNode {
    static void copyForward(LLVMPointer target, LLVMPointer source, long length, ManagedMemMoveHelperNode helper, ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode) {
        int unitSize = unitSizeNode.execute(helper, length);
        for (long i = 0L; i < length; i += (long)unitSize) {
            helper.execute(target.increment(i), source.increment(i), unitSize);
        }
    }

    private static void copyBackward(LLVMPointer target, LLVMPointer source, long length, ManagedMemMoveHelperNode helper, ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode) {
        int unitSize = unitSizeNode.execute(helper, length);
        for (long i = length - (long)unitSize; i >= 0L; i -= (long)unitSize) {
            helper.execute(target.increment(i), source.increment(i), unitSize);
        }
    }

    static boolean doCustomVaListCopy(LLVMManagedPointer target, LLVMManagedPointer source) {
        if (source.getOffset() != 0L || target.getOffset() != 0L) {
            return false;
        }
        return target.getObject() instanceof LLVMLinuxAarch64VaListStorage && source.getObject() instanceof LLVMLinuxAarch64VaListStorage;
    }

    static boolean doCustomNativeToVaListCopy(LLVMManagedPointer target) {
        return target.getOffset() == 0L && target.getObject() instanceof LLVMLinuxAarch64VaListStorage;
    }

    @Specialization(limit="2", guards={"target.getObject() != source.getObject()", "doCustomVaListCopy(target, source)"})
    protected void doManagedCustomCopy(VirtualFrame frame, LLVMManagedPointer target, LLVMManagedPointer source, long length, @Cached LLVMVaListStorage.VAListPointerWrapperFactoryDelegate wrapperFactory, @Bind(value="wrapperFactory.execute(source.getObject())") Object sourceWrapper, @CachedLibrary(value="sourceWrapper") LLVMVaListLibrary vaListLibrary) {
        LLVMLinuxAarch64VaListStorage.checkMemmoveLength(target, length);
        vaListLibrary.copy(sourceWrapper, target.getObject(), (Frame)frame);
    }

    @Specialization(guards={"target.getObject() != source.getObject()", "doCustomVaListCopy(target, source)"}, replaces={"doManagedCustomCopy"})
    protected void doManagedCustomCopyUncached(VirtualFrame frame, LLVMManagedPointer target, LLVMManagedPointer source, long length) {
        LLVMLinuxAarch64VaListStorage.checkMemmoveLength(target, length);
        Object sourceWrapper = LLVMVaListStorageFactory.VAListPointerWrapperFactoryDelegateNodeGen.getUncached().execute(source.getObject());
        ((LLVMVaListLibrary)LLVMVaListLibrary.getFactory().getUncached(sourceWrapper)).copy(sourceWrapper, target.getObject(), (Frame)frame.materialize());
    }

    @Specialization(limit="8", guards={"helper.guard(target, source)", "target.getObject() != source.getObject()", "!doCustomVaListCopy(target, source)"})
    protected void doManagedNonAliasing(LLVMManagedPointer target, LLVMManagedPointer source, long length, @Cached(value="create(target, source)") ManagedMemMoveHelperNode helper, @Cached ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode) {
        NativeProfiledMemMove.copyForward(target, source, length, helper, unitSizeNode);
    }

    @Specialization(limit="8", guards={"helper.guard(target, source)", "target.getObject() == source.getObject()", "!doCustomVaListCopy(target, source)"})
    protected void doManagedAliasing(LLVMManagedPointer target, LLVMManagedPointer source, long length, @Cached(value="create(target, source)") ManagedMemMoveHelperNode helper, @Cached ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode, @Cached CountingConditionProfile canCopyForward) {
        if (canCopyForward.profile(Long.compareUnsigned(target.getOffset() - source.getOffset(), length) >= 0)) {
            NativeProfiledMemMove.copyForward(target, source, length, helper, unitSizeNode);
        } else {
            NativeProfiledMemMove.copyBackward(target, source, length, helper, unitSizeNode);
        }
    }

    @Specialization(limit="4", guards={"helper.guard(target, source)", "!doCustomNativeToVaListCopy(target)"})
    protected void doManagedNative(LLVMManagedPointer target, LLVMNativePointer source, long length, @Cached(value="create(target, source)") ManagedMemMoveHelperNode helper, @Cached ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode) {
        NativeProfiledMemMove.copyForward(target, source, length, helper, unitSizeNode);
    }

    @Specialization(limit="2", guards={"doCustomNativeToVaListCopy(target)"})
    protected void doManagedNativeCustomCopy(VirtualFrame frame, LLVMManagedPointer target, LLVMNativePointer source, long length, @Cached LLVMVaListStorage.VAListPointerWrapperFactoryDelegate wrapperFactory, @Bind(value="wrapperFactory.execute(source)") Object sourceWrapper, @CachedLibrary(value="sourceWrapper") LLVMVaListLibrary vaListLibrary) {
        LLVMLinuxAarch64VaListStorage.checkMemmoveLength(target, length);
        vaListLibrary.copy(sourceWrapper, target.getObject(), (Frame)frame);
    }

    @Specialization(guards={"doCustomNativeToVaListCopy(target)"}, replaces={"doManagedNativeCustomCopy"})
    protected void doManagedNativeCustomCopyUncached(VirtualFrame frame, LLVMManagedPointer target, LLVMNativePointer source, long length) {
        LLVMLinuxAarch64VaListStorage.checkMemmoveLength(target, length);
        Object sourceWrapper = LLVMVaListStorageFactory.VAListPointerWrapperFactoryDelegateNodeGen.getUncached().execute(source);
        ((LLVMVaListLibrary)LLVMVaListLibrary.getFactory().getUncached(sourceWrapper)).copy(sourceWrapper, target.getObject(), (Frame)frame.materialize());
    }

    @Specialization
    protected void doNativeManaged(LLVMNativePointer target, LLVMManagedPointer source, long length, @Cached NativeProfiledMemMoveToNative nativeMemmove) {
        nativeMemmove.executeNative(target, source, length);
    }

    static boolean isManaged(LLVMPointer ptr) {
        return LLVMManagedPointer.isInstance(ptr);
    }

    @Specialization(guards={"isManaged(target) || isManaged(source)"}, replaces={"doManagedNonAliasing", "doManagedCustomCopyUncached", "doManagedAliasing", "doManagedNative", "doManagedNativeCustomCopyUncached", "doNativeManaged"})
    protected void doManagedSlowPath(VirtualFrame frame, LLVMPointer target, LLVMPointer source, long length) {
        this.doManagedSlowPathBoundary(frame.materialize(), target, source, length);
    }

    @CompilerDirectives.TruffleBoundary
    protected void doManagedSlowPathBoundary(MaterializedFrame frame, LLVMPointer target, LLVMPointer source, long length) {
        ManagedMemMoveHelperNode helper = ManagedMemMoveHelperNode.createSlowPath(target, source);
        ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode = ManagedMemMoveHelperNodeGen.UnitSizeNodeGen.create();
        LLVMVaListLibrary vaListLibrary = (LLVMVaListLibrary)LLVMVaListLibrary.getFactory().getUncached();
        LLVMVaListStorage.VAListPointerWrapperFactoryDelegate wrapperFactory = LLVMVaListStorageFactory.VAListPointerWrapperFactoryDelegateNodeGen.getUncached();
        if (LLVMManagedPointer.isInstance(target) && LLVMManagedPointer.isInstance(source)) {
            this.doManagedAliasing(LLVMManagedPointer.cast(target), LLVMManagedPointer.cast(source), length, helper, unitSizeNode, CountingConditionProfile.getUncached());
        } else if (LLVMManagedPointer.isInstance(target) && LLVMManagedPointer.isInstance(source) && NativeProfiledMemMove.doCustomVaListCopy(LLVMManagedPointer.cast(target), LLVMManagedPointer.cast(source))) {
            LLVMLinuxAarch64VaListStorage.checkMemmoveLength(target, length);
            vaListLibrary.copy(wrapperFactory.execute(LLVMManagedPointer.cast(source).getObject()), LLVMManagedPointer.cast(target).getObject(), (Frame)frame);
        } else if (LLVMManagedPointer.isInstance(target) && LLVMNativePointer.isInstance(source) && NativeProfiledMemMove.doCustomNativeToVaListCopy(LLVMManagedPointer.cast(target))) {
            LLVMLinuxAarch64VaListStorage.checkMemmoveLength(target, length);
            vaListLibrary.copy(wrapperFactory.execute(source), LLVMManagedPointer.cast(target).getObject(), (Frame)frame);
        } else {
            NativeProfiledMemMove.copyForward(target, source, length, helper, unitSizeNode);
        }
    }

    @Specialization(replaces={"doNativeManaged", "doManagedSlowPath"})
    protected void doNative(LLVMPointer target, LLVMPointer source, long length, @Cached LLVMToNativeNode convertTarget, @Cached NativeProfiledMemMoveToNative nativeMemmove) {
        nativeMemmove.executeNative(convertTarget.executeWithTarget(target), source, length);
    }
}

