/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public final class LLVMNativePointerSupport
extends LLVMNode {
    private static LLVMNativePointerSupport UNCACHED = new LLVMNativePointerSupport(true);
    @Node.Child
    private InternalLibrary delegate;

    private LLVMNativePointerSupport(boolean uncached) {
        this.delegate = new InternalLibrary(uncached);
    }

    public static LLVMNativePointerSupport create() {
        return new LLVMNativePointerSupport(false);
    }

    public static LLVMNativePointerSupport getUncached() {
        return UNCACHED;
    }

    public LLVMNativeLibrary getLibrary() {
        return this.delegate;
    }

    public boolean isPointer(Object receiver) {
        return this.delegate.isPointer(receiver);
    }

    public long asPointer(Object receiver) throws UnsupportedMessageException {
        return this.delegate.asPointer(receiver);
    }

    public LLVMNativePointer toNativePointer(Object receiver) {
        return this.delegate.toNativePointer(receiver);
    }

    public static final class InternalLibrary
    extends LLVMNativeLibrary
    implements GenerateAOT.Provider {
        @Node.Child
        private IsPointerNode isPointerNode;
        @Node.Child
        private AsPointerNode asPointerNode;
        @Node.Child
        private ToNativePointerNode toNativePointerNode;

        private InternalLibrary(boolean uncached) {
            if (uncached) {
                this.isPointerNode = LLVMNativePointerSupportFactory.IsPointerNodeGen.getUncached();
                this.asPointerNode = LLVMNativePointerSupportFactory.AsPointerNodeGen.getUncached();
                this.toNativePointerNode = LLVMNativePointerSupportFactory.ToNativePointerNodeGen.getUncached();
            }
        }

        @Override
        public boolean isPointer(Object receiver) {
            if (this.isPointerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isPointerNode = (IsPointerNode)this.insert(LLVMNativePointerSupportFactory.IsPointerNodeGen.create());
            }
            return this.isPointerNode.execute(receiver);
        }

        @Override
        public long asPointer(Object receiver) throws UnsupportedMessageException {
            if (this.asPointerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.asPointerNode = (AsPointerNode)this.insert(LLVMNativePointerSupportFactory.AsPointerNodeGen.create());
            }
            return this.asPointerNode.execute(receiver);
        }

        @Override
        public LLVMNativePointer toNativePointer(Object receiver) {
            if (this.toNativePointerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toNativePointerNode = (ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            }
            return this.toNativePointerNode.execute(receiver);
        }

        public boolean accepts(Object receiver) {
            return true;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            this.isPointerNode = (IsPointerNode)this.insert(LLVMNativePointerSupportFactory.IsPointerNodeGen.create());
            ((GenerateAOT.Provider)this.isPointerNode).prepareForAOT(language, root);
            this.asPointerNode = (AsPointerNode)this.insert(LLVMNativePointerSupportFactory.AsPointerNodeGen.create());
            ((GenerateAOT.Provider)this.asPointerNode).prepareForAOT(language, root);
            this.toNativePointerNode = (ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            ((GenerateAOT.Provider)this.toNativePointerNode).prepareForAOT(language, root);
        }
    }

    @GenerateUncached
    public static abstract class ToNativePointerNode
    extends LLVMNode {
        public abstract LLVMNativePointer execute(Object var1);

        @Specialization
        LLVMNativePointer doNativePointer(LLVMNativePointer receiver) {
            return receiver;
        }

        @Specialization
        LLVMNativePointer doManagedPointer(LLVMManagedPointer receiver, @Cached ToNativePointerHelper toNativePointerHelper) {
            return toNativePointerHelper.execute(receiver.getObject()).increment(receiver.getOffset());
        }

        @Fallback
        LLVMNativePointer doOther(Object receiver, @Cached ToNativePointerHelper toNativePointerHelper) {
            return toNativePointerHelper.execute(receiver);
        }

        @GenerateUncached
        static abstract class ToNativePointerHelper
        extends LLVMNode {
            ToNativePointerHelper() {
            }

            abstract LLVMNativePointer execute(Object var1);

            @Specialization
            LLVMNativePointer doLong(long x) {
                return LLVMNativePointer.create(x);
            }

            @Specialization
            LLVMNativePointer doByteArray(byte[] x) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Cannot convert virtual allocation object to native pointer.");
            }

            @Specialization
            LLVMNativePointer doFunctionDescriptor(LLVMFunctionDescriptor functionDescriptor, @Cached BranchProfile exceptionProfile) {
                try {
                    return functionDescriptor.asNativePointer(exceptionProfile);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new LLVMPolyglotException(this, e.getMessage());
                }
            }

            @Fallback
            @GenerateAOT.Exclude
            LLVMNativePointer doOther(Object x, @CachedLibrary(limit="1") LLVMNativeLibrary natives) {
                natives.accepts(x);
                return natives.toNativePointer(x);
            }
        }
    }

    @GenerateUncached
    public static abstract class AsPointerNode
    extends LLVMNode {
        public abstract long execute(Object var1) throws UnsupportedMessageException;

        @Specialization
        long doNativePointer(LLVMNativePointer receiver) {
            return receiver.asNative();
        }

        @Specialization
        long doManagedPointer(LLVMManagedPointer receiver, @Cached AsPointerHelper asPointerHelper) {
            return asPointerHelper.execute(receiver.getObject()) + receiver.getOffset();
        }

        @Fallback
        long doOther(Object receiver, @Cached AsPointerHelper asPointerHelper) {
            return asPointerHelper.execute(receiver);
        }

        @GenerateUncached
        static abstract class AsPointerHelper
        extends LLVMNode {
            AsPointerHelper() {
            }

            abstract long execute(Object var1);

            @Specialization
            long doLong(long x) {
                return x;
            }

            @Specialization
            long doFunctionDescriptor(LLVMFunctionDescriptor functionDescriptor, @Cached BranchProfile exception) {
                try {
                    return functionDescriptor.asPointer(exception);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new LLVMPolyglotException(this, e.getMessage());
                }
            }

            @Fallback
            @GenerateAOT.Exclude
            long doOther(Object x, @CachedLibrary(limit="1") LLVMNativeLibrary natives) {
                try {
                    return natives.asPointer(x);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new LLVMPolyglotException(this, e.getMessage());
                }
            }
        }
    }

    @GenerateUncached
    public static abstract class IsPointerNode
    extends LLVMNode {
        public abstract boolean execute(Object var1);

        @Specialization
        boolean doNativePointer(LLVMNativePointer receiver) {
            return true;
        }

        @Specialization
        boolean doManagedPointer(LLVMManagedPointer receiver, @Cached IsPointerHelper isPointerHelper) {
            return isPointerHelper.execute(receiver.getObject());
        }

        @Fallback
        boolean doOther(Object receiver, @Cached IsPointerHelper isPointerHelper) {
            return isPointerHelper.execute(receiver);
        }

        @GenerateUncached
        static abstract class IsPointerHelper
        extends LLVMNode {
            IsPointerHelper() {
            }

            abstract boolean execute(Object var1);

            @Specialization
            boolean doLong(long x) {
                return true;
            }

            @Specialization
            boolean doByteArray(byte[] x) {
                return false;
            }

            @Specialization
            boolean doFunctionDescriptor(LLVMFunctionDescriptor functionDescriptor) {
                return functionDescriptor.isPointer();
            }

            @Fallback
            @GenerateAOT.Exclude
            boolean doOther(Object x, @CachedLibrary(limit="1") LLVMNativeLibrary natives) {
                return natives.isPointer(x);
            }
        }
    }
}

