/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public final class LLVMThreadKeyIntrinsics {

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="key"), @NodeChild(type=LLVMExpressionNode.class, value="value")})
    public static abstract class LLVMThreadSetSpecific
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(int key, LLVMPointer value) {
            if (!this.getContext().getpThreadContext().setSpecific(key, value)) {
                return 22;
            }
            return 0;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="key")
    public static abstract class LLVMThreadGetSpecific
    extends LLVMBuiltin {
        @Specialization
        protected LLVMPointer doIntrinsic(int key) {
            LLVMPointer value = this.getContext().getpThreadContext().getSpecific(key);
            return value != null ? value : LLVMNativePointer.createNull();
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="key")
    public static abstract class LLVMThreadKeyDelete
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(int key) {
            this.getContext().getpThreadContext().deletePThreadKey(key);
            return 0;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="destructor")
    public static abstract class LLVMThreadKeyCreate
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(LLVMPointer destructor) {
            return this.getContext().getpThreadContext().createPThreadKey(destructor);
        }
    }
}

