/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.Type;

public abstract class LLVMVAListNode
extends LLVMExpressionNode {
    protected final Assumption allocatesVAListPointer;
    private final Type vaListType;

    protected LLVMVAListNode(Type vaListType) {
        LLVMLanguage language = LLVMLanguage.get(null);
        PlatformCapability capability = language.getCapability(PlatformCapability.class);
        this.vaListType = capability.getGlobalVAListType(vaListType);
        this.allocatesVAListPointer = Truffle.getRuntime().createAssumption("This node allocates a VA list pointer.");
    }

    LLVMExpressionNode createAllocaNode() {
        DataLayout dataLayout = this.getDataLayout();
        LLVMLanguage language = LLVMLanguage.get(null);
        PlatformCapability capability = language.getCapability(PlatformCapability.class);
        return language.getActiveConfiguration().createNodeFactory(language, dataLayout).createAlloca(this.vaListType, capability.getVAListAlignment());
    }

    public Assumption getAssumption() {
        return this.allocatesVAListPointer;
    }

    @Specialization(guards={"getAssumption().isValid()"})
    public LLVMManagedPointer createVAList(VirtualFrame frame, @Cached(value="createAllocaNode()") LLVMExpressionNode allocaNode) {
        LLVMNativePointer vaListNativeStackPtr = allocaNode == null ? LLVMNativePointer.createNull() : LLVMNativePointer.cast(allocaNode.executeGeneric(frame));
        Object vaListStorage = LLVMLanguage.get(this).getCapability(PlatformCapability.class).createVAListStorage(this, vaListNativeStackPtr, this.vaListType);
        return LLVMManagedPointer.create(vaListStorage);
    }

    @Fallback
    public LLVMNativePointer allocateNative(VirtualFrame frame, @Cached(value="createAllocaNode()") LLVMExpressionNode allocaNode) {
        return LLVMNativePointer.cast(allocaNode.executeGeneric(frame));
    }
}

