/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

public abstract class LLVMVectorReduce {

    @NodeChild(type=LLVMExpressionNode.class)
    @NodeField(name="vectorLength", type=int.class)
    public static abstract class LLVMVectorReduceSignedMinNode
    extends LLVMBuiltin {
        protected abstract int getVectorLength();

        @Specialization
        @ExplodeLoop
        protected byte doVector(LLVMI8Vector value) {
            assert (value.getLength() == this.getVectorLength());
            byte min = 127;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                byte elem = value.getValue(i);
                if (elem >= min) continue;
                min = elem;
            }
            return min;
        }

        @Specialization
        @ExplodeLoop
        protected short doVector(LLVMI16Vector value) {
            assert (value.getLength() == this.getVectorLength());
            short min = Short.MAX_VALUE;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                short elem = value.getValue(i);
                if (elem >= min) continue;
                min = elem;
            }
            return min;
        }

        @Specialization
        @ExplodeLoop
        protected int doVector(LLVMI32Vector value) {
            assert (value.getLength() == this.getVectorLength());
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int elem = value.getValue(i);
                if (elem >= min) continue;
                min = elem;
            }
            return min;
        }

        @Specialization
        @ExplodeLoop
        protected long doVector(LLVMI64Vector value) {
            assert (value.getLength() == this.getVectorLength());
            long min = Long.MAX_VALUE;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long elem = value.getValue(i);
                if (elem >= min) continue;
                min = elem;
            }
            return min;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    @NodeField(name="vectorLength", type=int.class)
    public static abstract class LLVMVectorReduceSignedMaxNode
    extends LLVMBuiltin {
        protected abstract int getVectorLength();

        @Specialization
        @ExplodeLoop
        protected byte doVector(LLVMI8Vector value) {
            assert (value.getLength() == this.getVectorLength());
            byte max = -128;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                byte elem = value.getValue(i);
                if (elem <= max) continue;
                max = elem;
            }
            return max;
        }

        @Specialization
        @ExplodeLoop
        protected short doVector(LLVMI16Vector value) {
            assert (value.getLength() == this.getVectorLength());
            short max = Short.MIN_VALUE;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                short elem = value.getValue(i);
                if (elem <= max) continue;
                max = elem;
            }
            return max;
        }

        @Specialization
        @ExplodeLoop
        protected int doVector(LLVMI32Vector value) {
            assert (value.getLength() == this.getVectorLength());
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int elem = value.getValue(i);
                if (elem <= max) continue;
                max = elem;
            }
            return max;
        }

        @Specialization
        @ExplodeLoop
        protected long doVector(LLVMI64Vector value) {
            assert (value.getLength() == this.getVectorLength());
            long max = Long.MIN_VALUE;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long elem = value.getValue(i);
                if (elem <= max) continue;
                max = elem;
            }
            return max;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    @NodeField(name="vectorLength", type=int.class)
    public static abstract class LLVMVectorReduceUnsignedMinNode
    extends LLVMBuiltin {
        protected abstract int getVectorLength();

        @Specialization
        @ExplodeLoop
        protected byte doVector(LLVMI8Vector value) {
            assert (value.getLength() == this.getVectorLength());
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int elem = value.getValue(i) & 0xFF;
                if (elem >= min) continue;
                min = elem;
            }
            return (byte)min;
        }

        @Specialization
        @ExplodeLoop
        protected short doVector(LLVMI16Vector value) {
            assert (value.getLength() == this.getVectorLength());
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int elem = value.getValue(i) & 0xFFFF;
                if (elem >= min) continue;
                min = elem;
            }
            return (short)min;
        }

        @Specialization
        @ExplodeLoop
        protected int doVector(LLVMI32Vector value) {
            assert (value.getLength() == this.getVectorLength());
            long min = Long.MAX_VALUE;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long elem = (long)value.getValue(i) & 0xFFFFFFFFL;
                if (elem >= min) continue;
                min = elem;
            }
            return (int)min;
        }

        @Specialization
        @ExplodeLoop
        protected long doVector(LLVMI64Vector value) {
            assert (value.getLength() == this.getVectorLength());
            long min = Long.MAX_VALUE;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long elem = value.getValue(i);
                if (Long.compareUnsigned(elem, min) >= 0) continue;
                min = elem;
            }
            return (int)min;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    @NodeField(name="vectorLength", type=int.class)
    public static abstract class LLVMVectorReduceUnsignedMaxNode
    extends LLVMBuiltin {
        protected abstract int getVectorLength();

        @Specialization
        @ExplodeLoop
        protected byte doVector(LLVMI8Vector value) {
            assert (value.getLength() == this.getVectorLength());
            int max = 0;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int elem = value.getValue(i) & 0xFF;
                if (elem <= max) continue;
                max = elem;
            }
            return (byte)max;
        }

        @Specialization
        @ExplodeLoop
        protected short doVector(LLVMI16Vector value) {
            assert (value.getLength() == this.getVectorLength());
            int max = 0;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int elem = value.getValue(i) & 0xFFFF;
                if (elem <= max) continue;
                max = elem;
            }
            return (short)max;
        }

        @Specialization
        @ExplodeLoop
        protected int doVector(LLVMI32Vector value) {
            assert (value.getLength() == this.getVectorLength());
            long max = 0L;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long elem = (long)value.getValue(i) & 0xFFFFFFFFL;
                if (elem <= max) continue;
                max = elem;
            }
            return (int)max;
        }

        @Specialization
        @ExplodeLoop
        protected long doVector(LLVMI64Vector value) {
            assert (value.getLength() == this.getVectorLength());
            long min = Long.MAX_VALUE;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                long elem = value.getValue(i);
                if (Long.compareUnsigned(elem, min) <= 0) continue;
                min = elem;
            }
            return (int)min;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    @NodeField(name="vectorLength", type=int.class)
    public static abstract class LLVMVectorReduceXorNode
    extends LLVMBuiltin {
        protected abstract int getVectorLength();

        @Specialization
        @ExplodeLoop
        protected boolean doVector(LLVMI1Vector value) {
            assert (value.getLength() == this.getVectorLength());
            boolean result = false;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result ^= value.getValue(i);
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected byte doVector(LLVMI8Vector value) {
            assert (value.getLength() == this.getVectorLength());
            byte result = 0;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result = (byte)(result ^ value.getValue(i));
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected short doVector(LLVMI16Vector value) {
            assert (value.getLength() == this.getVectorLength());
            short result = 0;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result = (short)(result ^ value.getValue(i));
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected int doVector(LLVMI32Vector value) {
            assert (value.getLength() == this.getVectorLength());
            int result = 0;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result ^= value.getValue(i);
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected long doVector(LLVMI64Vector value) {
            assert (value.getLength() == this.getVectorLength());
            long result = 0L;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result ^= value.getValue(i);
            }
            return result;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    @NodeField(name="vectorLength", type=int.class)
    public static abstract class LLVMVectorReduceOrNode
    extends LLVMBuiltin {
        protected abstract int getVectorLength();

        @Specialization
        @ExplodeLoop
        protected boolean doVector(LLVMI1Vector value) {
            assert (value.getLength() == this.getVectorLength());
            boolean result = false;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result |= value.getValue(i);
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected byte doVector(LLVMI8Vector value) {
            assert (value.getLength() == this.getVectorLength());
            byte result = 0;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result = (byte)(result | value.getValue(i));
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected short doVector(LLVMI16Vector value) {
            assert (value.getLength() == this.getVectorLength());
            short result = 0;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result = (short)(result | value.getValue(i));
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected int doVector(LLVMI32Vector value) {
            assert (value.getLength() == this.getVectorLength());
            int result = 0;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result |= value.getValue(i);
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected long doVector(LLVMI64Vector value) {
            assert (value.getLength() == this.getVectorLength());
            long result = 0L;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result |= value.getValue(i);
            }
            return result;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    @NodeField(name="vectorLength", type=int.class)
    public static abstract class LLVMVectorReduceAndNode
    extends LLVMBuiltin {
        protected abstract int getVectorLength();

        @Specialization
        @ExplodeLoop
        protected boolean doVector(LLVMI1Vector value) {
            assert (value.getLength() == this.getVectorLength());
            boolean result = true;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result &= value.getValue(i);
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected byte doVector(LLVMI8Vector value) {
            assert (value.getLength() == this.getVectorLength());
            byte result = -1;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result = (byte)(result & value.getValue(i));
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected short doVector(LLVMI16Vector value) {
            assert (value.getLength() == this.getVectorLength());
            short result = -1;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result = (short)(result & value.getValue(i));
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected int doVector(LLVMI32Vector value) {
            assert (value.getLength() == this.getVectorLength());
            int result = -1;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result &= value.getValue(i);
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected long doVector(LLVMI64Vector value) {
            assert (value.getLength() == this.getVectorLength());
            long result = -1L;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result &= value.getValue(i);
            }
            return result;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    @NodeField(name="vectorLength", type=int.class)
    public static abstract class LLVMVectorReduceMulNode
    extends LLVMBuiltin {
        protected abstract int getVectorLength();

        @Specialization
        @ExplodeLoop
        protected byte doVector(LLVMI8Vector value) {
            assert (value.getLength() == this.getVectorLength());
            byte result = 1;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result = (byte)(result * value.getValue(i));
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected short doVector(LLVMI16Vector value) {
            assert (value.getLength() == this.getVectorLength());
            short result = 1;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result = (short)(result * value.getValue(i));
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected int doVector(LLVMI32Vector value) {
            assert (value.getLength() == this.getVectorLength());
            int result = 1;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result *= value.getValue(i);
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected long doVector(LLVMI64Vector value) {
            assert (value.getLength() == this.getVectorLength());
            long result = 1L;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result *= value.getValue(i);
            }
            return result;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    @NodeField(name="vectorLength", type=int.class)
    public static abstract class LLVMVectorReduceAddNode
    extends LLVMBuiltin {
        protected abstract int getVectorLength();

        @Specialization
        @ExplodeLoop
        protected byte doVector(LLVMI8Vector value) {
            assert (value.getLength() == this.getVectorLength());
            byte result = 0;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result = (byte)(result + value.getValue(i));
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected short doVector(LLVMI16Vector value) {
            assert (value.getLength() == this.getVectorLength());
            short result = 0;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result = (short)(result + value.getValue(i));
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected int doVector(LLVMI32Vector value) {
            assert (value.getLength() == this.getVectorLength());
            int result = 0;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result += value.getValue(i);
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected long doVector(LLVMI64Vector value) {
            assert (value.getLength() == this.getVectorLength());
            long result = 0L;
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result += value.getValue(i);
            }
            return result;
        }
    }
}

