/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;

@NodeChildren(value={@NodeChild(value="a", type=LLVMExpressionNode.class), @NodeChild(value="b", type=LLVMExpressionNode.class), @NodeChild(value="c", type=LLVMExpressionNode.class), @NodeChild(value="d", type=LLVMExpressionNode.class)})
public abstract class LLVMComplexFloatDiv
extends LLVMExpressionNode {
    @Specialization
    public LLVMFloatVector doFloat(float a, float b, float c, float d) {
        float denom = c * c + d * d;
        float zReal = (a * c + b * d) / denom;
        float zImag = (b * c - a * d) / denom;
        float[] values = new float[]{zReal, zImag};
        return LLVMFloatVector.create(values);
    }
}

