/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemCopyNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.move.LLVMPrimitiveMoveNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="destination"), @NodeChild(type=LLVMExpressionNode.class, value="source"), @NodeChild(type=LLVMExpressionNode.class, value="length"), @NodeChild(type=LLVMExpressionNode.class, value="isVolatile")})
public abstract class LLVMMemCopy
extends LLVMBuiltin {
    @Node.Child
    private LLVMMemMoveNode memMove;

    public LLVMMemCopy(LLVMMemMoveNode memMove) {
        this.memMove = memMove;
    }

    public static LLVMExpressionNode createIntrinsic(LLVMExpressionNode[] args, LLVMMemMoveNode memMove, NodeFactory nodeFactory) {
        LLVMExpressionNode serialMovesReplacement = LLVMPrimitiveMoveNode.createSerialMoves(args, nodeFactory, memMove);
        if (serialMovesReplacement != null) {
            return serialMovesReplacement;
        }
        if (args.length == 6) {
            return LLVMMemCopyNodeGen.create(memMove, args[1], args[2], args[3], args[5]);
        }
        if (args.length == 5) {
            return LLVMMemCopyNodeGen.create(memMove, args[1], args[2], args[3], args[4]);
        }
        throw new LLVMParserException("Illegal number of arguments to @llvm.memcpy.*: " + args.length);
    }

    @Specialization
    protected Object doVoid(VirtualFrame frame, LLVMPointer target, LLVMPointer source, int length, boolean isVolatile) {
        return this.doVoid(frame, target, source, (long)length, isVolatile);
    }

    @Specialization
    protected Object doVoid(VirtualFrame frame, LLVMPointer target, LLVMPointer source, long length, boolean isVolatile) {
        this.memMove.executeWithTarget(frame, target, source, length);
        return null;
    }

    @Specialization
    protected Object doVoid(VirtualFrame frame, LLVMPointer target, LLVMPointer source, LLVMPointer length, boolean isVolatile, @Cached LLVMToNativeNode toNative) {
        return this.doVoid(frame, target, source, toNative.executeWithTarget(length).asNative(), isVolatile);
    }
}

