/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointer;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMTruffleGetArg
extends LLVMIntrinsic {
    @Node.Child
    private ToPointer toPointer = ToPointer.create();

    @Specialization(rewriteOn={ArrayIndexOutOfBoundsException.class})
    protected Object doIntrinsic(VirtualFrame frame, int index) {
        Object[] arguments = frame.getArguments();
        return this.toPointer.executeWithTarget(arguments[1 + index]);
    }

    @Specialization
    protected Object doWithBoundsCheck(VirtualFrame frame, int index) {
        Object[] arguments = frame.getArguments();
        if (index < 0 || index + 1 >= arguments.length) {
            throw new LLVMPolyglotException((Node)this, "Argument index %d out of bounds.", index);
        }
        return this.toPointer.executeWithTarget(arguments[1 + index]);
    }
}

