/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.memory.LLVMHandleMemoryBase;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class GraalVMIsHandle
extends LLVMIntrinsic {
    @Specialization
    protected boolean doLongCase(long address) {
        if (!this.getLanguage().getNoDerefHandleAssumption().isValid() && LLVMHandleMemoryBase.isDerefHandleMemory(address)) {
            return this.getContext().getDerefHandleContainer().isHandle(address);
        }
        if (!this.getLanguage().getNoCommonHandleAssumption().isValid() && LLVMHandleMemoryBase.isCommonHandleMemory(address)) {
            return this.getContext().getHandleContainer().isHandle(address);
        }
        return false;
    }

    @Specialization
    protected boolean doPointerCase(LLVMNativePointer a) {
        return this.doLongCase(a.asNative());
    }

    @Fallback
    protected boolean doGeneric(Object object) {
        return false;
    }
}

