/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMDLOpen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
public abstract class LLVMDLSym
extends LLVMIntrinsic {
    @Specialization(guards={"isLLVMLibrary(libraryHandle)"}, limit="2")
    @GenerateAOT.Exclude
    protected Object doOp(LLVMManagedPointer libraryHandle, LLVMPointer symbol, @Cached LLVMReadStringNode readStr, @CachedLibrary(value="getLibrary(libraryHandle)") InteropLibrary interop, @Cached WrappedFunctionNode wrapper) {
        try {
            String symbolName = readStr.executeWithTarget(symbol);
            Object function = interop.readMember(this.getLibrary(libraryHandle), symbolName);
            return wrapper.execute(function);
        }
        catch (InteropException e) {
            this.getContext().setDLError(2);
            return LLVMNativePointer.createNull();
        }
    }

    @Specialization(guards={"!(isLLVMLibrary(libraryHandle))"})
    protected Object doOp(LLVMManagedPointer libraryHandle, LLVMPointer symbol, @Cached LLVMReadStringNode readStr) {
        return LLVMNativePointer.createNull();
    }

    @Specialization(guards={"isRtldDefault(libraryHandle)"})
    protected Object doDefaultHandle(LLVMNativePointer libraryHandle, LLVMPointer symbolName, @Cached LLVMReadStringNode readStr, @Cached WrappedFunctionNode wrapper, @Cached BranchProfile exception) {
        LLVMContext ctx = LLVMContext.get(this);
        String name = readStr.executeWithTarget(symbolName);
        LLVMSymbol symbol = ctx.getGlobalScopeChain().get(name);
        if (symbol == null) {
            Object nativeSymbol = this.getNativeSymbol(name, ctx);
            if (nativeSymbol == null) {
                ctx.setDLError(2);
                return LLVMNativePointer.createNull();
            }
            return wrapper.execute(nativeSymbol);
        }
        return ctx.getSymbol(symbol, exception);
    }

    @CompilerDirectives.TruffleBoundary
    protected Object getNativeSymbol(String name, LLVMContext context) {
        NativeContextExtension.NativeLookupResult result;
        NativeContextExtension nativeContextExtension = context.getContextExtensionOrNull(NativeContextExtension.class);
        if (nativeContextExtension != null && (result = nativeContextExtension.getNativeFunctionOrNull(name)) != null) {
            return result.getObject();
        }
        return null;
    }

    protected boolean isRtldDefault(LLVMNativePointer libraryHandle) {
        PlatformCapability sysContextExt = LLVMLanguage.get(null).getCapability(PlatformCapability.class);
        return sysContextExt.isDefaultDLSymFlagSet(libraryHandle.asNative());
    }

    protected Object getLibrary(LLVMManagedPointer pointer) {
        return ((LLVMDLOpen.LLVMDLHandler)pointer.getObject()).getLibrary();
    }

    protected boolean isLLVMLibrary(LLVMManagedPointer library) {
        return library.getObject() instanceof LLVMDLOpen.LLVMDLHandler;
    }

    static abstract class WrappedFunctionNode
    extends LLVMNode {
        WrappedFunctionNode() {
        }

        abstract LLVMPointer execute(Object var1);

        @Specialization
        protected LLVMManagedPointer doFunctionDescriptor(LLVMFunctionDescriptor function) {
            return LLVMManagedPointer.create(function);
        }

        @Specialization(guards={"!isFunctionDescriptor(symbol)", "interopLibrary.isPointer(symbol)"}, limit="1")
        @GenerateAOT.Exclude
        protected LLVMNativePointer doNFISymbol(Object symbol, @CachedLibrary(value="symbol") InteropLibrary interopLibrary) {
            try {
                return LLVMNativePointer.create(interopLibrary.asPointer(symbol));
            }
            catch (InteropException e) {
                this.getContext().setDLError(2);
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        protected static boolean isFunctionDescriptor(Object function) {
            return function instanceof LLVMFunctionDescriptor;
        }
    }
}

