/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLookupDispatchTargetNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLookupDispatchTargetNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessGlobalSymbolNodeGen;

public abstract class LLVMLookupDispatchTargetSymbolNode
extends LLVMExpressionNode {
    protected final LLVMFunction function;

    protected LLVMLookupDispatchTargetSymbolNode(LLVMFunction function) {
        this.function = function;
    }

    @Specialization(guards={"function.getFixedCodeAssumption().isValid()", "code != null", "code.isLLVMIRFunction() || code.isIntrinsicFunctionSlowPath()"})
    protected LLVMFunctionCode getCode(@Bind(value="function.getFixedCode()") LLVMFunctionCode code) {
        return code;
    }

    @Specialization(replaces={"getCode"})
    protected Object getGeneric(VirtualFrame frame, @Cached(value="createLookupNode()") LLVMLookupDispatchTargetNode node) {
        return node.executeGeneric(frame);
    }

    protected LLVMLookupDispatchTargetNode createLookupNode() {
        return LLVMLookupDispatchTargetNodeGen.create(LLVMAccessGlobalSymbolNodeGen.create(this.function));
    }
}

