/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLookupDispatchTargetNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLookupDispatchTargetSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessGlobalSymbolNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessGlobalSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChild(value="function", type=LLVMExpressionNode.class)
public abstract class LLVMLookupDispatchTargetNode
extends LLVMExpressionNode {
    protected static final int INLINE_CACHE_SIZE = 5;

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"isSameObject(pointer.getObject(), cachedDescriptor)", "cachedDescriptor != null", "pointer.getOffset() == 0", "isSingleContext($node)"})
    protected static LLVMFunctionDescriptor doDirectCached(LLVMManagedPointer pointer, @Cached(value="asFunctionDescriptor(pointer.getObject())") LLVMFunctionDescriptor cachedDescriptor) {
        return cachedDescriptor;
    }

    @Specialization(guards={"isFunctionDescriptor(pointer.getObject())", "pointer.getOffset() == 0"}, replaces={"doDirectCached"})
    protected static LLVMFunctionDescriptor doDirect(LLVMManagedPointer pointer) {
        return (LLVMFunctionDescriptor)pointer.getObject();
    }

    @Specialization(guards={"foreigns.isForeign(pointer.getObject())", "pointer.getOffset() == 0"})
    @GenerateAOT.Exclude
    protected Object doForeign(LLVMManagedPointer pointer, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns) {
        return pointer.getObject();
    }

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"pointer.asNative() == cachedAddress", "!isAutoDerefHandle(cachedAddress)", "cachedDescriptor != null", "isSingleContext($node)"})
    protected static LLVMFunctionDescriptor doHandleCached(LLVMNativePointer pointer, @Cached(value="pointer.asNative()") long cachedAddress, @Cached(value="lookupFunction(pointer)") LLVMFunctionDescriptor cachedDescriptor) {
        return cachedDescriptor;
    }

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"pointer.asNative() == cachedAddress", "!isAutoDerefHandle(cachedAddress)", "cachedDescriptor == null", "isSingleContext($node)"})
    protected static LLVMNativePointer doNativeFunctionCached(LLVMNativePointer pointer, @Cached(value="pointer.asNative()") long cachedAddress, @Cached(value="lookupFunction(pointer)") LLVMFunctionDescriptor cachedDescriptor) {
        return pointer;
    }

    @Specialization(guards={"!isAutoDerefHandle(pointer.asNative())", "cachedSymbol != null"}, replaces={"doHandleCached", "doNativeFunctionCached"}, rewriteOn={LLVMIllegalSymbolIndexException.class})
    protected Object doLookupNativeFunctionCachedSymbol(VirtualFrame frame, LLVMNativePointer pointer, @Cached(value="lookupFunctionSymbol(pointer)") LLVMAccessGlobalSymbolNode cachedSymbol) {
        LLVMFunctionDescriptor descriptor;
        long nativePointer;
        LLVMManagedPointer managedPointer;
        LLVMPointer symbolPointer = cachedSymbol.executeGeneric(frame);
        if (LLVMManagedPointer.isInstance(symbolPointer) && (managedPointer = LLVMManagedPointer.cast(symbolPointer)).getOffset() == 0L && managedPointer.getObject() instanceof LLVMFunctionDescriptor && (nativePointer = (descriptor = (LLVMFunctionDescriptor)managedPointer.getObject()).getNativePointer()) != 0L && nativePointer == pointer.asNative()) {
            return descriptor;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new LLVMIllegalSymbolIndexException("mismatching function");
    }

    @Specialization(guards={"!isAutoDerefHandle(pointer.asNative())"}, replaces={"doLookupNativeFunctionCachedSymbol", "doHandleCached", "doNativeFunctionCached"})
    protected Object doLookup(LLVMNativePointer pointer) {
        LLVMFunctionDescriptor descriptor = this.lookupFunction(pointer);
        if (descriptor != null) {
            return descriptor;
        }
        return pointer;
    }

    @Specialization(guards={"isAutoDerefHandle(pointer.asNative())"})
    protected Object doDerefHandle(LLVMNativePointer pointer, @Cached LLVMDerefHandleGetReceiverNode getReceiver) {
        LLVMManagedPointer foreignFunction = getReceiver.execute(pointer);
        return foreignFunction.getObject();
    }

    protected LLVMFunctionDescriptor lookupFunction(LLVMNativePointer function) {
        return this.getContext().getFunctionDescriptor(function);
    }

    protected LLVMAccessGlobalSymbolNode lookupFunctionSymbol(LLVMNativePointer function) {
        CompilerAsserts.neverPartOfCompilation();
        LLVMContext context = this.getContext();
        LLVMFunctionDescriptor descriptor = context.getFunctionDescriptor(function);
        return descriptor == null || descriptor.getLLVMFunction() == null ? null : LLVMAccessGlobalSymbolNodeGen.create(descriptor.getLLVMFunction());
    }

    public static LLVMExpressionNode createOptimized(LLVMExpressionNode function) {
        LLVMAccessGlobalSymbolNode node;
        if (function instanceof LLVMAccessGlobalSymbolNode && (node = (LLVMAccessGlobalSymbolNode)function).getSymbol() instanceof LLVMFunction) {
            return LLVMLookupDispatchTargetSymbolNodeGen.create((LLVMFunction)node.getSymbol());
        }
        return LLVMLookupDispatchTargetNodeGen.create(function);
    }
}

