/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

@NodeChildren(value={@NodeChild(value="syscallNum"), @NodeChild(value="arg1"), @NodeChild(value="arg2"), @NodeChild(value="arg3"), @NodeChild(value="arg4"), @NodeChild(value="arg5"), @NodeChild(value="arg6")})
public abstract class LLVMSyscallNode
extends LLVMExpressionNode {
    protected static final int NUM_SYSCALLS = 332;

    protected LLVMSyscallOperationNode createNode(long syscallNum) {
        return LLVMLanguage.get(null).getCapability(PlatformCapability.class).createSyscallNode(syscallNum);
    }

    @Specialization(guards={"syscallNum == cachedSyscallNum"}, limit="NUM_SYSCALLS", rewriteOn={UnexpectedResultException.class})
    protected long cachedSyscall(long syscallNum, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, @Cached(value="syscallNum") long cachedSyscallNum, @Cached(value="createNode(syscallNum)") LLVMSyscallOperationNode node) throws UnexpectedResultException {
        if (LLVMContext.logSysCallsEnabled()) {
            LLVMSyscallNode.trace("[sulong] syscall: %s (%s, %s, %s, %s, %s, %s)\n", LLVMSyscallNode.getNodeName(node), arg1, arg2, arg3, arg4, arg5, arg6);
        }
        try {
            long result = node.executeLong(arg1, arg2, arg3, arg4, arg5, arg6);
            if (LLVMContext.logSysCallsEnabled()) {
                LLVMSyscallNode.trace("         result: %d\n", result);
            }
            return result;
        }
        catch (UnexpectedResultException ex) {
            Object result = ex.getResult();
            if (LLVMContext.logSysCallsEnabled()) {
                LLVMSyscallNode.trace("         result: %s\n", result);
            }
            throw ex;
        }
    }

    @Specialization(guards={"syscallNum == cachedSyscallNum"}, limit="NUM_SYSCALLS", replaces={"cachedSyscall"})
    protected Object cachedSyscallGeneric(long syscallNum, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, @Cached(value="syscallNum") long cachedSyscallNum, @Cached(value="createNode(syscallNum)") LLVMSyscallOperationNode node) {
        if (LLVMContext.logSysCallsEnabled()) {
            LLVMSyscallNode.trace("[sulong] syscall: %s (%s, %s, %s, %s, %s, %s)\n", LLVMSyscallNode.getNodeName(node), arg1, arg2, arg3, arg4, arg5, arg6);
        }
        Object result = node.executeGeneric(arg1, arg2, arg3, arg4, arg5, arg6);
        if (LLVMContext.logSysCallsEnabled()) {
            LLVMSyscallNode.trace("         result: %s\n", result);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private static String getNodeName(LLVMSyscallOperationNode node) {
        return node.getName();
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(replaces={"cachedSyscallGeneric"})
    protected Object doGeneric(long syscallNum, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        return this.createNode(syscallNum).executeGeneric(arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @CompilerDirectives.TruffleBoundary
    private static void trace(String format, Object ... args) {
        LLVMContext.logSysCall(String.format(format, args));
    }
}

