/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteAddressRegisterNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMAMD64WriteAddressRegisterNode.class)
public final class LLVMAMD64WriteAddressRegisterNodeGen
extends LLVMAMD64WriteAddressRegisterNode
implements GenerateAOT.Provider {
    private final int slot;
    @Node.Child
    private LLVMExpressionNode value_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMAMD64WriteAddressRegisterNodeGen(LLVMExpressionNode value, int slot) {
        this.slot = slot;
        this.value_ = value;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x3C) == 0 && (state_0 & 0x3E) != 0) {
            this.execute_byte0(state_0, frameValue);
            return;
        }
        if ((state_0 & 0x3A) == 0 && (state_0 & 0x3E) != 0) {
            this.execute_short1(state_0, frameValue);
            return;
        }
        if ((state_0 & 0x36) == 0 && (state_0 & 0x3E) != 0) {
            this.execute_int2(state_0, frameValue);
            return;
        }
        if ((state_0 & 0x2E) == 0 && (state_0 & 0x3E) != 0) {
            this.execute_long3(state_0, frameValue);
            return;
        }
        this.execute_generic4(state_0, frameValue);
    }

    private void execute_byte0(int state_0__, VirtualFrame frameValue) {
        byte valueValue_;
        int state_0 = state_0__;
        try {
            valueValue_ = this.value_.executeI8(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            this.executeAndSpecialize(frameValue, valueValue_);
            return;
        }
        assert ((state_0 & 2) != 0);
        this.doI8(frameValue, valueValue_);
    }

    private void execute_short1(int state_0__, VirtualFrame frameValue) {
        short valueValue_;
        int state_0 = state_0__;
        try {
            valueValue_ = this.value_.executeI16(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            this.executeAndSpecialize(frameValue, valueValue_);
            return;
        }
        assert ((state_0 & 4) != 0);
        this.doI16(frameValue, valueValue_);
    }

    private void execute_int2(int state_0__, VirtualFrame frameValue) {
        int valueValue_;
        int state_0 = state_0__;
        try {
            valueValue_ = this.value_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            this.executeAndSpecialize(frameValue, valueValue_);
            return;
        }
        assert ((state_0 & 8) != 0);
        this.doI32(frameValue, valueValue_);
    }

    private void execute_long3(int state_0__, VirtualFrame frameValue) {
        long valueValue_;
        int state_0 = state_0__;
        try {
            valueValue_ = this.value_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            this.executeAndSpecialize(frameValue, valueValue_);
            return;
        }
        assert ((state_0 & 0x10) != 0);
        this.doI64(frameValue, valueValue_);
    }

    private void execute_generic4(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            this.executeAndSpecialize(frameValue, valueValue_);
            return;
        }
        if ((state_0 & 0x3E) != 0) {
            if ((state_0 & 2) != 0 && valueValue_ instanceof Byte) {
                byte valueValue__ = (Byte)valueValue_;
                this.doI8(frameValue, valueValue__);
                return;
            }
            if ((state_0 & 4) != 0 && valueValue_ instanceof Short) {
                short valueValue__ = (Short)valueValue_;
                this.doI16(frameValue, valueValue__);
                return;
            }
            if ((state_0 & 8) != 0 && valueValue_ instanceof Integer) {
                int valueValue__ = (Integer)valueValue_;
                this.doI32(frameValue, valueValue__);
                return;
            }
            if ((state_0 & 0x10) != 0 && valueValue_ instanceof Long) {
                long valueValue__ = (Long)valueValue_;
                this.doI64(frameValue, valueValue__);
                return;
            }
            if ((state_0 & 0x20) != 0 && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                this.doAddress(frameValue, valueValue__);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, valueValue_);
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object valueValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (valueValue instanceof Byte) {
            byte valueValue_ = (Byte)valueValue;
            this.state_0_ = state_0 |= 2;
            this.doI8(frameValue, valueValue_);
            return;
        }
        if (valueValue instanceof Short) {
            short valueValue_ = (Short)valueValue;
            this.state_0_ = state_0 |= 4;
            this.doI16(frameValue, valueValue_);
            return;
        }
        if (valueValue instanceof Integer) {
            int valueValue_ = (Integer)valueValue;
            this.state_0_ = state_0 |= 8;
            this.doI32(frameValue, valueValue_);
            return;
        }
        if (valueValue instanceof Long) {
            long valueValue_ = (Long)valueValue;
            this.state_0_ = state_0 |= 0x10;
            this.doI64(frameValue, valueValue_);
            return;
        }
        if (LLVMTypes.isPointer(valueValue)) {
            LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
            this.state_0_ = state_0 |= 0x20;
            this.doAddress(frameValue, valueValue_);
            return;
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.value_}, new Object[]{valueValue});
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        this.state_0_ |= 4;
        this.state_0_ |= 8;
        this.state_0_ |= 0x10;
        this.state_0_ |= 0x20;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMAMD64WriteAddressRegisterNode create(LLVMExpressionNode value, int slot) {
        return new LLVMAMD64WriteAddressRegisterNodeGen(value, slot);
    }
}

