/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteBooleanNode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;

public abstract class LLVMAMD64RdSeedNode
extends LLVMExpressionNode {
    private final SecureRandom random = new SecureRandom();
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeCFNode;

    @CompilerDirectives.TruffleBoundary
    protected short getSeedI16() {
        byte[] seed = this.random.generateSeed(2);
        return (short)(Byte.toUnsignedInt(seed[0]) << 8 | Byte.toUnsignedInt(seed[1]));
    }

    @CompilerDirectives.TruffleBoundary
    protected int getSeedI32() {
        byte[] seed = this.random.generateSeed(4);
        return ByteBuffer.wrap(seed).order(ByteOrder.nativeOrder()).getInt();
    }

    @CompilerDirectives.TruffleBoundary
    protected long getSeedI64() {
        byte[] seed = this.random.generateSeed(8);
        return ByteBuffer.wrap(seed).order(ByteOrder.nativeOrder()).getLong();
    }

    public LLVMAMD64RdSeedNode(LLVMAMD64WriteBooleanNode cf) {
        this.writeCFNode = cf;
    }

    public static abstract class LLVMAMD64RdSeedqNode
    extends LLVMAMD64RdSeedNode {
        public LLVMAMD64RdSeedqNode(LLVMAMD64WriteBooleanNode cf) {
            super(cf);
        }

        @Specialization
        protected long doI64(VirtualFrame frame) {
            this.writeCFNode.execute(frame, true);
            return this.getSeedI64();
        }
    }

    public static abstract class LLVMAMD64RdSeedlNode
    extends LLVMAMD64RdSeedNode {
        public LLVMAMD64RdSeedlNode(LLVMAMD64WriteBooleanNode cf) {
            super(cf);
        }

        @Specialization
        protected int doI32(VirtualFrame frame) {
            this.writeCFNode.execute(frame, true);
            return this.getSeedI32();
        }
    }

    public static abstract class LLVMAMD64RdSeedwNode
    extends LLVMAMD64RdSeedNode {
        public LLVMAMD64RdSeedwNode(LLVMAMD64WriteBooleanNode cf) {
            super(cf);
        }

        @Specialization
        protected short doI16(VirtualFrame frame) {
            this.writeCFNode.execute(frame, true);
            return this.getSeedI16();
        }
    }
}

