/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LongDivision;

public abstract class LLVMAMD64DivNode
extends LLVMStatementNode {
    private static final String QUOTIENT_TOO_LARGE = "quotient too large";

    @NodeChildren(value={@NodeChild(value="high", type=LLVMExpressionNode.class), @NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64DivqNode
    extends LLVMAMD64DivNode {
        @Node.Child
        private LLVMAMD64WriteTupelNode out;

        public LLVMAMD64DivqNode(LLVMAMD64WriteTupelNode out) {
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, long high, long left, long right, @Cached BranchProfile exception) {
            LongDivision.Result result = LongDivision.divu128by64(high, left, right);
            if (result.isInvalid()) {
                exception.enter();
                throw new QuotientTooLargeException();
            }
            long quotient = result.quotient;
            long remainder = result.remainder;
            this.out.execute(frame, quotient, remainder);
        }
    }

    @NodeChildren(value={@NodeChild(value="high", type=LLVMExpressionNode.class), @NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64DivlNode
    extends LLVMAMD64DivNode {
        @Node.Child
        private LLVMAMD64WriteTupelNode out;

        public LLVMAMD64DivlNode(LLVMAMD64WriteTupelNode out) {
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, int high, int left, int right, @Cached BranchProfile exception) {
            long value = Integer.toUnsignedLong(high) << 32 | Integer.toUnsignedLong(left);
            long quotient = Long.divideUnsigned(value, Integer.toUnsignedLong(right));
            long remainder = Long.remainderUnsigned(value, Integer.toUnsignedLong(right));
            if (quotient > 0xFFFFFFFFL) {
                exception.enter();
                throw new QuotientTooLargeException();
            }
            this.out.execute(frame, (int)quotient, (int)remainder);
        }
    }

    @NodeChildren(value={@NodeChild(value="high", type=LLVMExpressionNode.class), @NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64DivwNode
    extends LLVMAMD64DivNode {
        @Node.Child
        private LLVMAMD64WriteTupelNode out;

        public LLVMAMD64DivwNode(LLVMAMD64WriteTupelNode out) {
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, short high, short left, short right, @Cached BranchProfile exception) {
            int value = Short.toUnsignedInt(high) << 16 | Short.toUnsignedInt(left);
            int quotient = Integer.divideUnsigned(value, Short.toUnsignedInt(right));
            int remainder = Integer.remainderUnsigned(value, Short.toUnsignedInt(right));
            if (quotient > 65535) {
                exception.enter();
                throw new QuotientTooLargeException();
            }
            this.out.execute(frame, (short)quotient, (short)remainder);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64DivbNode
    extends LLVMAMD64DivNode {
        @Node.Child
        private LLVMAMD64WriteValueNode out;

        public LLVMAMD64DivbNode(LLVMAMD64WriteValueNode out) {
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, short left, byte right, @Cached BranchProfile exception) {
            int quotient = Short.toUnsignedInt(left) / Byte.toUnsignedInt(right);
            int remainder = Short.toUnsignedInt(left) % Byte.toUnsignedInt(right);
            if (quotient > 255) {
                exception.enter();
                throw new QuotientTooLargeException();
            }
            this.out.execute(frame, (short)(quotient & 0xFF | (remainder & 0xFF) << 8));
        }
    }

    static class QuotientTooLargeException
    extends ArithmeticException {
        static final long serialVersionUID = 1L;

        QuotientTooLargeException() {
            super(LLVMAMD64DivNode.QUOTIENT_TOO_LARGE);
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }
}

