/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode;

@NodeChild(value="valueNode")
public abstract class LLVMAMD64DecNode
extends LLVMExpressionNode {
    @Node.Child
    protected LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode flags;

    public LLVMAMD64DecNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode flags) {
        this.flags = flags;
    }

    public static abstract class LLVMAMD64DecqNode
    extends LLVMAMD64DecNode {
        public LLVMAMD64DecqNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected long doI64(VirtualFrame frame, long value) {
            long result = value - 1L;
            boolean of = value == Long.MIN_VALUE;
            this.flags.execute(frame, of, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64DeclNode
    extends LLVMAMD64DecNode {
        public LLVMAMD64DeclNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected int doI32(VirtualFrame frame, int value) {
            int result = value - 1;
            boolean of = value == Integer.MIN_VALUE;
            this.flags.execute(frame, of, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64DecwNode
    extends LLVMAMD64DecNode {
        public LLVMAMD64DecwNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected short doI16(VirtualFrame frame, short value) {
            short result = (short)(value - 1);
            boolean of = value == Short.MIN_VALUE;
            this.flags.execute(frame, of, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64DecbNode
    extends LLVMAMD64DecNode {
        public LLVMAMD64DecbNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected byte doI8(VirtualFrame frame, byte value) {
            byte result = (byte)(value - 1);
            boolean of = value == -128;
            this.flags.execute(frame, of, result);
            return result;
        }
    }
}

