/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode;

@NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
public abstract class LLVMAMD64CmpNode
extends LLVMStatementNode {
    @Node.Child
    protected LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags;

    public LLVMAMD64CmpNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags) {
        this.flags = flags;
    }

    public static abstract class LLVMAMD64CmpqNode
    extends LLVMAMD64CmpNode {
        public LLVMAMD64CmpqNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected void doOp(VirtualFrame frame, long left, long right) {
            long result = left - right;
            boolean overflow = ((left ^ right) & (left ^ result)) < 0L;
            boolean carry = Long.compareUnsigned(left, right) < 0;
            boolean adjust = ((left ^ right ^ result) & 0x10L) != 0L;
            this.flags.execute(frame, overflow, carry, adjust, result);
        }
    }

    public static abstract class LLVMAMD64CmplNode
    extends LLVMAMD64CmpNode {
        public LLVMAMD64CmplNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected void doOp(VirtualFrame frame, int left, int right) {
            int result = left - right;
            boolean overflow = ((left ^ right) & (left ^ result)) < 0;
            boolean carry = Integer.compareUnsigned(left, right) < 0;
            boolean adjust = ((left ^ right ^ result) & 0x10) != 0;
            this.flags.execute(frame, overflow, carry, adjust, result);
        }
    }

    public static abstract class LLVMAMD64CmpwNode
    extends LLVMAMD64CmpNode {
        public LLVMAMD64CmpwNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected void doOp(VirtualFrame frame, short left, short right) {
            int result = left - right;
            boolean overflow = (short)((left ^ right) & (left ^ result)) < 0;
            boolean carry = Short.toUnsignedInt(left) < Short.toUnsignedInt(right);
            boolean adjust = ((left ^ right ^ result) & 0x10) != 0;
            this.flags.execute(frame, overflow, carry, adjust, result);
        }
    }

    public static abstract class LLVMAMD64CmpbNode
    extends LLVMAMD64CmpNode {
        public LLVMAMD64CmpbNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected void doOp(VirtualFrame frame, byte left, byte right) {
            int result = left - right;
            boolean overflow = (byte)((left ^ right) & (left ^ result)) < 0;
            boolean carry = Byte.toUnsignedInt(left) < Byte.toUnsignedInt(right);
            boolean adjust = ((left ^ right ^ result) & 0x10) != 0;
            this.flags.execute(frame, overflow, carry, adjust, result);
        }
    }
}

