/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMFrameNullerUtil;

public abstract class LLVMFrameNullerExpression
extends LLVMExpressionNode {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] frameSlots;
    @Node.Child
    private LLVMExpressionNode expression;

    public LLVMFrameNullerExpression(int[] frameSlots, LLVMExpressionNode expression) {
        this.frameSlots = frameSlots;
        this.expression = expression;
    }

    @Override
    public String toString() {
        return this.getShortString("frameSlots");
    }

    @ExplodeLoop
    private void nullSlots(VirtualFrame frame) {
        for (int i = 0; i < this.frameSlots.length; ++i) {
            LLVMFrameNullerUtil.nullFrameSlot(frame, this.frameSlots[i]);
        }
    }

    @Specialization
    public Object doGeneric(VirtualFrame frame) {
        try {
            Object object = this.expression.executeGeneric(frame);
            return object;
        }
        finally {
            this.nullSlots(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        try {
            double d = this.expression.executeDouble(frame);
            return d;
        }
        finally {
            this.nullSlots(frame);
        }
    }

    @Override
    public float executeFloat(VirtualFrame frame) throws UnexpectedResultException {
        try {
            float f = this.expression.executeFloat(frame);
            return f;
        }
        finally {
            this.nullSlots(frame);
        }
    }

    @Override
    public short executeI16(VirtualFrame frame) throws UnexpectedResultException {
        try {
            short s = this.expression.executeI16(frame);
            return s;
        }
        finally {
            this.nullSlots(frame);
        }
    }

    @Override
    public boolean executeI1(VirtualFrame frame) throws UnexpectedResultException {
        try {
            boolean bl = this.expression.executeI1(frame);
            return bl;
        }
        finally {
            this.nullSlots(frame);
        }
    }

    @Override
    public int executeI32(VirtualFrame frame) throws UnexpectedResultException {
        try {
            int n = this.expression.executeI32(frame);
            return n;
        }
        finally {
            this.nullSlots(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeI64(VirtualFrame frame) throws UnexpectedResultException {
        try {
            long l = this.expression.executeI64(frame);
            return l;
        }
        finally {
            this.nullSlots(frame);
        }
    }

    @Override
    public byte executeI8(VirtualFrame frame) throws UnexpectedResultException {
        try {
            byte by = this.expression.executeI8(frame);
            return by;
        }
        finally {
            this.nullSlots(frame);
        }
    }
}

