/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;

@GenerateUncached
public abstract class ToI8
extends ForeignToLLVM {
    @Specialization
    protected byte fromInt(int value) {
        return (byte)value;
    }

    @Specialization
    protected byte fromChar(char value) {
        return (byte)value;
    }

    @Specialization
    protected byte fromLong(long value) {
        return (byte)value;
    }

    @Specialization
    protected byte fromShort(short value) {
        return (byte)value;
    }

    @Specialization
    protected byte fromByte(byte value) {
        return value;
    }

    @Specialization
    protected byte fromFloat(float value) {
        return (byte)value;
    }

    @Specialization
    protected byte fromDouble(double value) {
        return (byte)value;
    }

    @Specialization
    protected byte fromBoolean(boolean value) {
        return (byte)(value ? 1 : 0);
    }

    @Specialization
    protected byte fromString(String value, @Cached BranchProfile exception) {
        return (byte)this.getSingleStringCharacter(value, exception);
    }

    @Specialization(limit="5", guards={"foreigns.isForeign(obj)", "interop.isNumber(foreigns.asForeign(obj))"})
    @GenerateAOT.Exclude
    protected byte fromForeign(Object obj, @CachedLibrary(value="obj") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
        try {
            return interop.asByte(foreigns.asForeign(obj));
        }
        catch (UnsupportedMessageException ex) {
            exception.enter();
            throw new LLVMPolyglotException(this, "Polyglot number can't be converted to byte.");
        }
    }

    @CompilerDirectives.TruffleBoundary
    static byte slowPathPrimitiveConvert(ForeignToLLVM thiz, Object value) throws UnsupportedTypeException {
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof Boolean) {
            return (byte)((Boolean)value != false ? 1 : 0);
        }
        if (value instanceof Character) {
            return (byte)((Character)value).charValue();
        }
        if (value instanceof String) {
            return (byte)thiz.getSingleStringCharacter((String)value, BranchProfile.getUncached());
        }
        try {
            return ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asByte(value);
        }
        catch (UnsupportedMessageException ex) {
            throw UnsupportedTypeException.create((Object[])new Object[]{value});
        }
    }
}

