/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMAccessForeignObjectNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropReadNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToDouble;
import com.oracle.truffle.llvm.runtime.interop.convert.ToFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI16;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI32;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI64;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI8;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointer;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.nio.ByteOrder;

@NodeChildren(value={@NodeChild(value="foreign", type=LLVMAccessForeignObjectNode.ForeignDummy.class, implicit=true), @NodeChild(value="offset", type=LLVMAccessForeignObjectNode.OffsetDummy.class, implicit=true), @NodeChild(value="resolve", type=LLVMAccessForeignObjectNode.ResolveNativePointerNode.class, executeWith={"foreign", "offset"}, implicit=true, allowUncached=true), @NodeChild(value="type", type=LLVMAccessForeignObjectNode.GetForeignTypeNode.class, executeWith={"resolve"}, implicit=true, allowUncached=true)})
public abstract class LLVMReadFromForeignObjectNode
extends LLVMAccessForeignObjectNode {

    @GenerateUncached
    public static abstract class ForeignReadPointerNode
    extends LLVMReadFromForeignObjectNode {
        public abstract LLVMPointer execute(Object var1, long var2);

        @Specialization
        @GenerateAOT.Exclude
        LLVMNativePointer doNative(Object foreign, long offset, LLVMNativePointer resolved, Object type) {
            return this.getLanguage().getLLVMMemory().getPointer((Node)this, resolved);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        LLVMNativePointer doBuffer(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached BranchProfile oobProfile) {
            try {
                long ret = interop.readBufferLong(resolved.getObject(), ByteOrder.nativeOrder(), resolved.getOffset());
                return LLVMNativePointer.create(ret);
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        @GenerateAOT.Exclude
        LLVMPointer doStructured(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Structured type, @Cached LLVMInteropReadNode interopRead) {
            Object ret = interopRead.execute(type, resolved.getObject(), resolved.getOffset(), ForeignToLLVM.ForeignToLLVMType.POINTER);
            return LLVMTypesGen.asPointer(ret);
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        LLVMPointer doFallback(Object foreign, long offset, LLVMManagedPointer resolved, Object type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached ToPointer toLLVM) {
            try {
                Object ret = interop.readArrayElement(resolved.getObject(), resolved.getOffset() / 8L);
                return LLVMTypesGen.asPointer(toLLVM.executeWithType(ret, null));
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error reading from foreign array.");
            }
        }
    }

    @GenerateUncached
    public static abstract class ForeignReadI64Node
    extends LLVMReadFromForeignObjectNode {
        public abstract Object execute(Object var1, long var2);

        public abstract long executeLong(Object var1, long var2) throws UnexpectedResultException;

        @Specialization
        @GenerateAOT.Exclude
        long doNative(Object foreign, long offset, LLVMNativePointer resolved, Object type) {
            return this.getLanguage().getLLVMMemory().getI64((Node)this, resolved);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        long doBuffer(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached BranchProfile oobProfile) {
            try {
                return interop.readBufferLong(resolved.getObject(), ByteOrder.nativeOrder(), resolved.getOffset());
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        @GenerateAOT.Exclude
        Object doStructured(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Structured type, @Cached LLVMInteropReadNode interopRead) {
            return interopRead.execute(type, resolved.getObject(), resolved.getOffset(), ForeignToLLVM.ForeignToLLVMType.I64);
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        Object doFallback(Object foreign, long offset, LLVMManagedPointer resolved, Object type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached ToI64 toLLVM) {
            try {
                Object ret = interop.readArrayElement(resolved.getObject(), resolved.getOffset() / 8L);
                return toLLVM.executeWithTarget(ret);
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error reading from foreign array.");
            }
        }
    }

    @GenerateUncached
    public static abstract class ForeignReadDoubleNode
    extends LLVMReadFromForeignObjectNode {
        public abstract double execute(Object var1, long var2);

        @Specialization
        double doNative(Object foreign, long offset, LLVMNativePointer resolved, Object type) {
            return this.getLanguage().getLLVMMemory().getDouble((Node)this, resolved);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        double doBuffer(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached BranchProfile oobProfile) {
            try {
                return interop.readBufferDouble(resolved.getObject(), ByteOrder.nativeOrder(), resolved.getOffset());
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        double doStructured(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Structured type, @Cached LLVMInteropReadNode interopRead) {
            Object ret = interopRead.execute(type, resolved.getObject(), resolved.getOffset(), ForeignToLLVM.ForeignToLLVMType.DOUBLE);
            return LLVMTypesGen.asDouble(ret);
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        double doFallback(Object foreign, long offset, LLVMManagedPointer resolved, Object type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached ToDouble toLLVM) {
            try {
                Object ret = interop.readArrayElement(resolved.getObject(), resolved.getOffset() / 8L);
                return LLVMTypesGen.asDouble(toLLVM.executeWithTarget(ret));
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error reading from foreign array.");
            }
        }
    }

    @GenerateUncached
    public static abstract class ForeignReadFloatNode
    extends LLVMReadFromForeignObjectNode {
        public abstract float execute(Object var1, long var2);

        @Specialization
        float doNative(Object foreign, long offset, LLVMNativePointer resolved, Object type) {
            return this.getLanguage().getLLVMMemory().getFloat((Node)this, resolved);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        float doBuffer(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached BranchProfile oobProfile) {
            try {
                return interop.readBufferFloat(resolved.getObject(), ByteOrder.nativeOrder(), resolved.getOffset());
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        float doStructured(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Structured type, @Cached LLVMInteropReadNode interopRead) {
            Object ret = interopRead.execute(type, resolved.getObject(), resolved.getOffset(), ForeignToLLVM.ForeignToLLVMType.FLOAT);
            return LLVMTypesGen.asFloat(ret);
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        float doFallback(Object foreign, long offset, LLVMManagedPointer resolved, Object type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached ToFloat toLLVM) {
            try {
                Object ret = interop.readArrayElement(resolved.getObject(), resolved.getOffset() / 4L);
                return LLVMTypesGen.asFloat(toLLVM.executeWithTarget(ret));
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error reading from foreign array.");
            }
        }
    }

    @GenerateUncached
    public static abstract class ForeignReadI32Node
    extends LLVMReadFromForeignObjectNode {
        public abstract int execute(Object var1, long var2);

        @Specialization
        int doNative(Object foreign, long offset, LLVMNativePointer resolved, Object type) {
            return this.getLanguage().getLLVMMemory().getI32((Node)this, resolved);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        int doBuffer(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached BranchProfile oobProfile) {
            try {
                return interop.readBufferInt(resolved.getObject(), ByteOrder.nativeOrder(), resolved.getOffset());
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        int doStructured(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Structured type, @Cached LLVMInteropReadNode interopRead) {
            Object ret = interopRead.execute(type, resolved.getObject(), resolved.getOffset(), ForeignToLLVM.ForeignToLLVMType.I32);
            return LLVMTypesGen.asInteger(ret);
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        int doFallback(Object foreign, long offset, LLVMManagedPointer resolved, Object type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached ToI32 toLLVM) {
            try {
                Object ret = interop.readArrayElement(resolved.getObject(), resolved.getOffset() / 4L);
                return LLVMTypesGen.asInteger(toLLVM.executeWithTarget(ret));
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error reading from foreign array.");
            }
        }
    }

    @GenerateUncached
    public static abstract class ForeignReadI16Node
    extends LLVMReadFromForeignObjectNode {
        public abstract short execute(Object var1, long var2);

        @Specialization
        short doNative(Object foreign, long offset, LLVMNativePointer resolved, Object type) {
            return this.getLanguage().getLLVMMemory().getI16((Node)this, resolved);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        short doBuffer(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached BranchProfile oobProfile) {
            try {
                return interop.readBufferShort(resolved.getObject(), ByteOrder.nativeOrder(), resolved.getOffset());
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        @GenerateAOT.Exclude
        short doStructured(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Structured type, @Cached LLVMInteropReadNode interopRead) {
            Object ret = interopRead.execute(type, resolved.getObject(), resolved.getOffset(), ForeignToLLVM.ForeignToLLVMType.I16);
            return LLVMTypesGen.asShort(ret);
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        short doFallback(Object foreign, long offset, LLVMManagedPointer resolved, Object type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached ToI16 toLLVM) {
            try {
                Object ret = interop.readArrayElement(resolved.getObject(), resolved.getOffset() / 2L);
                return LLVMTypesGen.asShort(toLLVM.executeWithTarget(ret));
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error reading from foreign array.");
            }
        }
    }

    @GenerateUncached
    public static abstract class ForeignReadI8Node
    extends LLVMReadFromForeignObjectNode {
        public abstract byte execute(Object var1, long var2);

        @Specialization
        byte doNative(Object foreign, long offset, LLVMNativePointer resolved, Object type) {
            return this.getLanguage().getLLVMMemory().getI8((Node)this, resolved);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        byte doBuffer(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached BranchProfile oobProfile) {
            try {
                return interop.readBufferByte(resolved.getObject(), resolved.getOffset());
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        byte doStructured(Object foreign, long offset, LLVMManagedPointer resolved, LLVMInteropType.Structured type, @Cached LLVMInteropReadNode interopRead) {
            Object ret = interopRead.execute(type, resolved.getObject(), resolved.getOffset(), ForeignToLLVM.ForeignToLLVMType.I8);
            return LLVMTypesGen.asByte(ret);
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        byte doFallback(Object foreign, long offset, LLVMManagedPointer resolved, Object type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached ToI8 toLLVM) {
            try {
                Object ret = interop.readArrayElement(resolved.getObject(), resolved.getOffset() / 1L);
                return LLVMTypesGen.asByte(toLLVM.executeWithTarget(ret));
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error reading from foreign array.");
            }
        }
    }
}

