/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.value;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugManagedValue;

@ExportLibrary(value=InteropLibrary.class)
public final class LLVMDebugManagedType
extends LLVMDebuggerValue {
    private final Object type;

    LLVMDebugManagedType(Object type) {
        this.type = type;
    }

    @ExportMessage
    boolean isMetaObject() {
        return true;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="getMetaSimpleName"), @ExportMessage(name="getMetaQualifiedName")})
    @CompilerDirectives.TruffleBoundary
    Object getMetaSimpleName() {
        return String.valueOf(this.type);
    }

    @ExportMessage
    boolean isMetaInstance(Object instance) {
        if (instance instanceof LLVMDebugManagedValue) {
            return ((LLVMDebugManagedValue)instance).llvmType == this.type;
        }
        return false;
    }

    @Override
    protected int getElementCountForDebugger() {
        return 0;
    }

    @Override
    protected String[] getKeysForDebugger() {
        return new String[0];
    }

    @Override
    protected Object getElementForDebugger(String key) {
        return null;
    }
}

