/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.type;

import com.oracle.truffle.api.CompilerDirectives;

final class IndexedTypeBounds {
    private static final int KEY_MIN_LENGTH = "[0]".length();

    @CompilerDirectives.TruffleBoundary
    static long toIndex(String key) {
        if (key != null && key.length() >= KEY_MIN_LENGTH) {
            try {
                return Integer.parseInt(key.substring(1, key.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    @CompilerDirectives.TruffleBoundary
    static String toKey(long index) {
        return String.format("[%d]", index);
    }

    private IndexedTypeBounds() {
    }
}

