/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprArrayElementNodeGen;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExpressionPair;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

@NodeInfo(shortName="[]")
@NodeChildren(value={@NodeChild(value="base", type=LLVMExpressionNode.class), @NodeChild(value="index", type=LLVMExpressionNode.class)})
public abstract class DebugExprArrayElementNode
extends LLVMExpressionNode {
    final DebugExprType type;

    public static DebugExprArrayElementNode create(DebugExpressionPair basePair, LLVMExpressionNode indexNode) {
        DebugExprType type = basePair.getType() == null ? DebugExprType.getVoidType() : basePair.getType().getInnerType();
        return DebugExprArrayElementNodeGen.create(type, basePair.getNode(), indexNode);
    }

    DebugExprArrayElementNode(DebugExprType type) {
        this.type = type;
    }

    public DebugExprType getType() {
        return this.type;
    }

    @Specialization
    @GenerateAOT.Exclude
    public Object doIntIndex(Object baseMember, int idx, @CachedLibrary(limit="3") InteropLibrary library, @Cached BranchProfile exception) {
        if (library.hasMembers(baseMember)) {
            try {
                Object arrayElement;
                String identifier;
                Object getmembers = library.getMembers(baseMember);
                if (library.isArrayElementReadable(getmembers, (long)idx) && library.isMemberReadable(baseMember, identifier = library.asString(arrayElement = library.readArrayElement(getmembers, (long)idx)))) {
                    Object member = library.readMember(baseMember, identifier);
                    return this.type.parse(member);
                }
            }
            catch (UnsupportedMessageException e) {
                exception.enter();
                throw DebugExprException.create(this, "Array access of %s not possible", baseMember);
            }
            catch (InvalidArrayIndexException e) {
                exception.enter();
                throw DebugExprException.create(this, "Invalid array index: %d", e.getInvalidIndex());
            }
            catch (UnknownIdentifierException e) {
                exception.enter();
                throw DebugExprException.symbolNotFound(this, e.getUnknownIdentifier(), baseMember);
            }
        }
        exception.enter();
        throw DebugExprException.create(this, "Array access of %s not possible", baseMember);
    }

    @CompilerDirectives.TruffleBoundary
    private static int toIntIndex(Object index) {
        return Integer.parseInt(index.toString());
    }

    @Specialization
    @GenerateAOT.Exclude
    public Object doGeneric(Object baseMember, Object index, @CachedLibrary(limit="3") InteropLibrary library, @Cached BranchProfile exception) {
        return this.doIntIndex(baseMember, DebugExprArrayElementNode.toIntIndex(index), library, exception);
    }
}

