/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.types.Type;

@CompilerDirectives.ValueType
public final class LLVMVarArgCompoundValue {
    private final Object addr;
    private final long size;
    private final int alignment;
    private final Type type;

    private LLVMVarArgCompoundValue(Object val, long size, int alignment, Type type) {
        this.addr = val;
        this.size = size;
        this.alignment = alignment;
        this.type = type;
    }

    public static LLVMVarArgCompoundValue create(Object val, long size, int alignment, Type type) {
        return new LLVMVarArgCompoundValue(val, size, alignment, type);
    }

    public Object getAddr() {
        return this.addr;
    }

    public long getSize() {
        return this.size;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LLVMVarArgCompoundValue) {
            LLVMVarArgCompoundValue curObj = (LLVMVarArgCompoundValue)obj;
            return curObj.addr.equals(this.addr) && curObj.size == this.size && curObj.alignment == this.alignment;
        }
        return false;
    }

    public int hashCode() {
        return this.addr.hashCode() + 11 * Long.hashCode(this.size) + 23 * Integer.hashCode(this.alignment);
    }

    public String toString() {
        return String.format("%s (%d align %d)", this.getAddr(), this.getSize(), this.getAlignment());
    }
}

