/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMException;

public final class LLVMUnsupportedException
extends LLVMException {
    private static final long serialVersionUID = 1L;

    public LLVMUnsupportedException(Node location, UnsupportedReason reason) {
        super(location, reason.getDescription());
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMUnsupportedException(Node location, UnsupportedReason reason, String details) {
        super(location, reason.getDescription() + ": " + details);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMUnsupportedException(Node location, UnsupportedReason reason, String format, Object ... args) {
        this(location, reason, String.format(format, args));
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMUnsupportedException(Node location, UnsupportedReason reason, Throwable cause) {
        super(location, reason.getDescription() + ": " + cause.getMessage(), cause);
    }

    public static enum UnsupportedReason {
        INLINE_ASSEMBLER("inline assembler"),
        SET_JMP_LONG_JMP("setjmp/longjmp"),
        PARSER_ERROR_VOID_SLOT("parser error void slot"),
        UNSUPPORTED_SYSCALL("unsupported syscall"),
        UNSUPPORTED_VALUE_RANGE("unsupported value range"),
        MISSING_BUILTIN("missing LLVM builtin");

        private final String description;

        private UnsupportedReason(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

