/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMElemPtrSymbol;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMThreadLocalSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;

public abstract class LLVMSymbol {
    public static final LLVMSymbol[] EMPTY = new LLVMSymbol[0];
    private final String name;
    private final IDGenerater.BitcodeID bitcodeID;
    private final int symbolIndex;
    private final boolean exported;
    private final boolean externalWeak;
    public static final int INVALID_INDEX = -1;

    public LLVMSymbol(String name, IDGenerater.BitcodeID bitcodeID, int symbolIndex, boolean exported, boolean externalWeak) {
        this.name = name;
        this.bitcodeID = bitcodeID;
        this.symbolIndex = symbolIndex;
        this.exported = exported;
        this.externalWeak = externalWeak;
    }

    public final String getName() {
        return this.name;
    }

    public final String getKind() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getClass().getSimpleName();
    }

    public final boolean isExported() {
        return this.exported;
    }

    public final boolean isExternalWeak() {
        return this.externalWeak;
    }

    public final int getSymbolIndexIllegalOk() {
        return this.symbolIndex;
    }

    public final int getSymbolIndex(BranchProfile exception) throws LLVMIllegalSymbolIndexException {
        if (this.symbolIndex >= 0) {
            return this.symbolIndex;
        }
        exception.enter();
        throw new LLVMIllegalSymbolIndexException("invalid symbol index");
    }

    public final int getSymbolIndexUncached() throws LLVMIllegalSymbolIndexException {
        CompilerAsserts.neverPartOfCompilation();
        return this.getSymbolIndex(BranchProfile.getUncached());
    }

    public final IDGenerater.BitcodeID getBitcodeIDIllegalOk() {
        return this.bitcodeID;
    }

    public final IDGenerater.BitcodeID getBitcodeID(BranchProfile exception) throws LLVMIllegalSymbolIndexException {
        if (this.bitcodeID != null) {
            return this.bitcodeID;
        }
        exception.enter();
        throw new LLVMIllegalSymbolIndexException("invalid bitcode ID");
    }

    public final IDGenerater.BitcodeID getBitcodeIDUncached() throws LLVMIllegalSymbolIndexException {
        CompilerAsserts.neverPartOfCompilation();
        return this.getBitcodeID(BranchProfile.getUncached());
    }

    public final boolean hasValidIndexAndID() {
        return this.symbolIndex >= 0 && this.bitcodeID != null;
    }

    public abstract boolean isGlobalVariable();

    public abstract boolean isFunction();

    public abstract boolean isAlias();

    public abstract boolean isElemPtrExpression();

    public abstract boolean isThreadLocalSymbol();

    public abstract LLVMFunction asFunction();

    public abstract LLVMGlobal asGlobalVariable();

    public abstract LLVMElemPtrSymbol asElemPtrExpression();

    public abstract LLVMThreadLocalSymbol asThreadLocalSymbol();
}

