/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInterface;
import com.oracle.truffle.llvm.runtime.SulongStackTrace;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.sulong.LLVMPrintStackTrace;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.Consumer;

public final class LLVMNodeUtils {
    public static String stackTrace(LLVMNode node) {
        StringLineWriter writer = new StringLineWriter();
        LLVMNodeUtils.printStackTrace(writer, node);
        return writer.toString();
    }

    public static String nodeAST(Node node) {
        StringLineWriter writer = new StringLineWriter();
        LLVMNodeUtils.printNodeAST(writer, node);
        return writer.toString();
    }

    public static String stackTraceAndAST(LLVMNode node) {
        StringLineWriter writer = new StringLineWriter();
        LLVMNodeUtils.printStackTrace(writer, node);
        writer.writeLine();
        LLVMNodeUtils.printNodeAST(writer, node);
        return writer.toString();
    }

    public static void printNodeAST(LineWriter writer, Node node) {
        LLVMNodeUtils.printNodeAST(writer, (NodeInterface)node, null, 1);
    }

    private static void printNodeAST(LineWriter writer, NodeInterface node, String fieldName, int level) {
        if (node == null) {
            return;
        }
        writer.writeLineFormat("%s%s = %s", "  ".repeat(level), fieldName, node);
        for (Class c = node.getClass(); c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                NodeInterface[] value2;
                if (Modifier.isStatic(field.getModifiers()) || "parent".equals(field.getName())) continue;
                if (NodeInterface.class.isAssignableFrom(field.getType())) {
                    try {
                        field.setAccessible(true);
                        value2 = (NodeInterface[])field.get(node);
                        if (value2 == null) continue;
                        LLVMNodeUtils.printNodeAST(writer, (NodeInterface)value2, field.getName(), level + 1);
                    }
                    catch (IllegalAccessException | RuntimeException value2) {}
                    continue;
                }
                if (!NodeInterface[].class.isAssignableFrom(field.getType())) continue;
                try {
                    field.setAccessible(true);
                    value2 = (NodeInterface[])field.get(node);
                    if (value2 == null) continue;
                    for (int i = 0; i < value2.length; ++i) {
                        LLVMNodeUtils.printNodeAST(writer, value2[i], field.getName() + "[" + i + "]", level + 1);
                    }
                }
                catch (IllegalAccessException | RuntimeException exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void printStackTrace(LineWriter writer, LLVMNode node) {
        SulongStackTrace stackTrace = LLVMPrintStackTrace.getStackTrace(node);
        for (SulongStackTrace.Element element : stackTrace.getTrace()) {
            writer.writeLine(element.toString());
        }
    }

    public static class StringLineWriter
    extends LineWriter {
        StringBuilder buffer = new StringBuilder();

        @Override
        public void writeLine(String line) {
            this.buffer.append(line);
            this.buffer.append('\n');
        }

        public String toString() {
            return this.buffer.toString();
        }
    }

    public static abstract class LineWriter {
        public void writeLine() {
            this.writeLine("");
        }

        public abstract void writeLine(String var1);

        public void writeLineFormat(String line, Object ... args) {
            this.writeLine(String.format(line, args));
        }
    }

    public static class LambdaLineWriter
    extends LineWriter {
        Consumer<String> lambda;

        public LambdaLineWriter(Consumer<String> lambda) {
            this.lambda = lambda;
        }

        @Override
        public void writeLine(String line) {
            this.lambda.accept(line);
        }
    }
}

