/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.llvm.runtime.Magic;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;

public class LLVMFileDetector
implements TruffleFile.FileTypeDetector {
    public String findMimeType(TruffleFile file) throws IOException {
        long magicWord = LLVMFileDetector.readMagicWord(file);
        return Magic.get((long)magicWord).mimeType;
    }

    public Charset findEncoding(TruffleFile file) throws IOException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long readMagicWord(TruffleFile file) {
        try (InputStream is = file.newInputStream(new OpenOption[]{StandardOpenOption.READ});){
            byte[] buffer = new byte[4];
            if (is.read(buffer) != buffer.length) {
                long l2 = 0L;
                return l2;
            }
            long l = Integer.toUnsignedLong(ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).getInt());
            return l;
        }
        catch (IOException | SecurityException e) {
            return 0L;
        }
    }
}

