/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public final class LLVMBitcodeLibraryFunctions {

    public static final class SulongEHUnwindWindowsNode
    extends LibraryFunctionNode {
        public SulongEHUnwindWindowsNode(LLVMContext context) {
            super(context, "__sulong_eh_unwind_windows");
        }

        public void unwind(LLVMStack stack, LLVMPointer thrownObject, LLVMPointer throwInfo, LLVMPointer imageBase) {
            this.execute(stack, thrownObject, throwInfo, imageBase);
        }
    }

    public static final class SulongEHCopyWindowsNode
    extends LibraryFunctionNode {
        public SulongEHCopyWindowsNode(LLVMContext context) {
            super(context, "__sulong_eh_copy_windows");
        }

        public void copy(LLVMStack stack, LLVMPointer thrownObject, LLVMPointer catchableType, LLVMPointer imageBase, LLVMPointer exceptionSlot, int attributes) {
            this.execute(stack, thrownObject, catchableType, imageBase, exceptionSlot, attributes);
        }
    }

    public static final class SulongCanCatchWindowsNode
    extends LibraryFunctionNode {
        public SulongCanCatchWindowsNode(LLVMContext context) {
            super(context, "__sulong_eh_canCatch_windows");
        }

        public LLVMPointer canCatch(LLVMStack stack, LLVMPointer thrownObject, LLVMPointer throwInfo, LLVMPointer catchType, LLVMPointer imageBase) {
            return LLVMPointer.cast(this.execute(stack, thrownObject, throwInfo, catchType.copy(), imageBase));
        }
    }

    public static final class SulongCanCatchNode
    extends LibraryFunctionNode {
        public SulongCanCatchNode(LLVMContext context) {
            super(context, "sulong_eh_canCatch");
        }

        public int canCatch(LLVMStack stack, Object unwindHeader, LLVMPointer catchType) {
            return (Integer)this.execute(stack, unwindHeader, catchType.copy());
        }
    }

    protected static abstract class LibraryFunctionNode
    extends LLVMNode {
        @Node.Child
        protected DirectCallNode callNode;

        protected LibraryFunctionNode(LLVMContext context, String name) {
            LLVMFunction function = context.getGlobalScopeChain().getFunction(name);
            if (function == null) {
                throw new LLVMLinkerException("Function not found: " + name);
            }
            LLVMFunctionDescriptor descriptor = context.createFunctionDescriptor(function, new LLVMFunctionCode(function));
            this.callNode = DirectCallNode.create((CallTarget)descriptor.getFunctionCode().getLLVMIRFunctionSlowPath());
        }

        protected Object execute(Object ... args) {
            return this.callNode.call(args);
        }
    }
}

