/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public final class DefaultLibraryLocator
extends LibraryLocator {
    public static final DefaultLibraryLocator INSTANCE = new DefaultLibraryLocator();

    private DefaultLibraryLocator() {
    }

    @Override
    public Object locateLibrary(LLVMContext context, String lib, Object reason) {
        Path libPath = Paths.get(lib, new String[0]);
        if (libPath.isAbsolute()) {
            return DefaultLibraryLocator.locateAbsolute(context, libPath);
        }
        return DefaultLibraryLocator.locateGlobal(context, lib);
    }

    public static Object locateGlobal(LLVMContext context, String lib) {
        Object internalLib = LLVMContext.InternalLocator.INSTANCE.locateLibrary(context, lib, "<locate global>");
        if (internalLib != null) {
            return internalLib;
        }
        List<Path> libraryPaths = context.getLibraryPaths();
        DefaultLibraryLocator.traceSearchPath(context, libraryPaths);
        for (Path p : libraryPaths) {
            Path absPath = Paths.get(p.toString(), lib);
            DefaultLibraryLocator.traceTry(context, absPath);
            TruffleFile file = context.getEnv().getInternalTruffleFile(absPath.toUri());
            if (!file.exists(new LinkOption[0])) continue;
            return file;
        }
        return null;
    }

    public static TruffleFile locateAbsolute(LLVMContext context, Path libPath) {
        assert (libPath.isAbsolute());
        DefaultLibraryLocator.traceTry(context, libPath);
        TruffleFile file = context.getEnv().getInternalTruffleFile(libPath.toUri());
        try {
            if (file.exists(new LinkOption[0])) {
                return file;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }
}

