/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class PhiInstruction
extends ValueInstruction {
    private final SymbolImpl[] values;
    private final InstructionBlock[] blocks;

    private PhiInstruction(Type type, int size) {
        super(type);
        this.values = new SymbolImpl[size];
        this.blocks = new InstructionBlock[size];
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public InstructionBlock getBlock(int index) {
        return this.blocks[index];
    }

    public int getSize() {
        return this.values.length;
    }

    public SymbolImpl getValue(int index) {
        return this.values[index];
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacment) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != original) continue;
            this.values[i] = replacment;
        }
    }

    public static PhiInstruction generate(SymbolTable symbols, Type type, int[] values, InstructionBlock[] blocks) {
        PhiInstruction phi = new PhiInstruction(type, values.length);
        for (int i = 0; i < values.length; ++i) {
            phi.values[i] = symbols.getForwardReferenced(values[i], phi);
            phi.blocks[i] = blocks[i];
        }
        return phi;
    }
}

