/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.metadata.MDExpression;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceVariable;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;

public final class DbgDeclareInstruction
extends VoidInstruction {
    private final SymbolImpl value;
    private final SourceVariable variable;
    private final MDExpression expression;

    public DbgDeclareInstruction(SymbolImpl value, SourceVariable variable, MDExpression expression) {
        this.value = value;
        this.variable = variable;
        this.expression = expression;
    }

    public SymbolImpl getValue() {
        return this.value;
    }

    public SourceVariable getVariable() {
        return this.variable;
    }

    public MDExpression getExpression() {
        return this.expression;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbgDeclareInstruction that = (DbgDeclareInstruction)o;
        if (!this.getValue().equals(that.getValue())) {
            return false;
        }
        if (!this.getVariable().equals(that.getVariable())) {
            return false;
        }
        return this.getExpression().equals(that.getExpression());
    }

    public int hashCode() {
        int result = this.getValue().hashCode();
        result = 31 * result + this.getVariable().hashCode();
        result = 31 * result + this.getExpression().hashCode();
        return result;
    }
}

