/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.AggregateConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class ArrayConstant
extends AggregateConstant {
    ArrayConstant(ArrayType type, int valueCount) {
        super(type, valueCount);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ArrayType getType() {
        return (ArrayType)super.getType();
    }

    @Override
    public String toString() {
        return String.format("[%s]", super.toString());
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        LLVMExpressionNode[] values = new LLVMExpressionNode[this.getElementCount()];
        for (int i = 0; i < this.getElementCount(); ++i) {
            values[i] = this.getElement(i).createNode(runtime, dataLayout, stackFactory);
        }
        return runtime.getNodeFactory().createArrayLiteral(values, this.getType(), stackFactory);
    }

    @Override
    public void addToBuffer(Constant.Buffer buffer, LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) throws Type.TypeOverflowException {
        long startOffset = buffer.getBuffer().position();
        long elementSize = this.getType().getElementType().getSize(dataLayout);
        assert (this.getType().getNumberOfElements() == (long)this.getElementCount());
        for (int i = 0; i < this.getElementCount(); ++i) {
            this.getElement(i).addToBuffer(buffer, runtime, dataLayout, stackFactory);
            buffer.getBuffer().position((int)(startOffset + (long)(i + 1) * elementSize));
        }
    }
}

