/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.enums;

public enum BinaryOperator {
    INT_ADD(13, "add"),
    INT_SUBTRACT(14, "sub"),
    INT_MULTIPLY(15, "mul"),
    INT_UNSIGNED_DIVIDE(-1, "udiv"),
    INT_SIGNED_DIVIDE(16, "sdiv"),
    INT_UNSIGNED_REMAINDER(-1, "urem"),
    INT_SIGNED_REMAINDER(17, "srem"),
    INT_SHIFT_LEFT(-1, "shl"),
    INT_LOGICAL_SHIFT_RIGHT(-1, "lshr"),
    INT_ARITHMETIC_SHIFT_RIGHT(-1, "ashr"),
    INT_AND(-1, "and"),
    INT_OR(-1, "or"),
    INT_XOR(-1, "xor"),
    FP_ADD(-1, "fadd"),
    FP_SUBTRACT(-1, "fsub"),
    FP_MULTIPLY(-1, "fmul"),
    FP_DIVIDE(-1, "fdiv"),
    FP_REMAINDER(-1, "frem");

    private static final BinaryOperator[] VALUES;
    private final int fpmap;
    private final String irString;

    public static BinaryOperator decode(int opcode, boolean isFloatingPoint) {
        if (opcode >= 0 && opcode <= INT_XOR.ordinal()) {
            BinaryOperator op = VALUES[opcode];
            return isFloatingPoint ? op.fp() : op;
        }
        return null;
    }

    private BinaryOperator(int fpmap, String irString) {
        this.fpmap = fpmap;
        this.irString = irString;
    }

    private BinaryOperator fp() {
        return this.fpmap < 0 ? null : VALUES[this.fpmap];
    }

    public boolean isFloatingPoint() {
        return this.ordinal() > INT_XOR.ordinal();
    }

    public String getIrString() {
        return this.irString;
    }

    static {
        VALUES = BinaryOperator.values();
    }
}

