/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDName;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;

public final class MDTemplateValue
extends MDName
implements MDBaseNode {
    private final long tag;
    private MDBaseNode type;
    private MDBaseNode value;
    private static final int ARGINDEX_TAG = 1;
    private static final int ARGINDEX_NAME = 2;
    private static final int ARGINDEX_TYPE = 3;
    private static final int ARGINDEX_VALUE = 4;

    private MDTemplateValue(long tag) {
        this.tag = tag;
        this.type = MDVoidNode.INSTANCE;
        this.value = MDVoidNode.INSTANCE;
    }

    public long getTag() {
        return this.tag;
    }

    public MDBaseNode getType() {
        return this.type;
    }

    public MDBaseNode getValue() {
        return this.value;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.type == oldValue) {
            this.type = newValue;
        }
        if (this.value == oldValue) {
            this.value = newValue;
        }
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public static MDTemplateValue create38(long[] args, MetadataValueList md) {
        long tag = args[1];
        MDTemplateValue templateValue = new MDTemplateValue(tag);
        templateValue.type = md.getNullable(args[3], templateValue);
        templateValue.value = md.getNullable(args[4], templateValue);
        templateValue.setName(md.getNullable(args[2], templateValue));
        return templateValue;
    }

    public static MDTemplateValue create32(long[] args, Metadata md) {
        MDTemplateValue templateValue = new MDTemplateValue(-1L);
        templateValue.type = ParseUtil.resolveReference(args, 3, templateValue, md);
        templateValue.value = ParseUtil.resolveSymbol(args, 4, md);
        templateValue.setName(ParseUtil.resolveReference(args, 2, templateValue, md));
        return templateValue;
    }
}

