/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;

public final class MDSubroutine
implements MDBaseNode {
    private final long flags;
    private MDBaseNode types;
    private static final int ARGINDEX_FLAGS = 1;
    private static final int ARGINDEX_TYPES = 2;

    private MDSubroutine(long flags) {
        this.flags = flags;
        this.types = MDVoidNode.INSTANCE;
    }

    public long getFlags() {
        return this.flags;
    }

    public MDBaseNode getTypes() {
        return this.types;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        if (this.types == oldValue) {
            this.types = newValue;
        }
    }

    public static MDSubroutine create38(long[] args, MetadataValueList md) {
        long flags = args[1];
        MDSubroutine subroutine = new MDSubroutine(flags);
        subroutine.types = md.getNullable(args[2], subroutine);
        return subroutine;
    }
}

