/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDAggregateNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;

public final class MDNode
extends MDAggregateNode {
    private MDNode(int size) {
        super(size);
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public static MDNode create38(RecordBuffer buffer, MetadataValueList md) {
        MDNode node = new MDNode(buffer.size());
        for (int i = 0; i < buffer.size(); ++i) {
            node.set(i, md.getNullable(buffer.read(), node));
        }
        return node;
    }

    public static MDNode create32(long[] record, Metadata md) {
        int size = record.length / 2;
        MDNode node = new MDNode(size);
        for (int i = 0; i < size; ++i) {
            node.set(i, ParseUtil.resolveReference(record, i, node, md));
        }
        return node;
    }
}

