/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDVariable;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;

public final class MDLocalVariable
extends MDVariable
implements MDBaseNode {
    private final long arg;
    private final long flags;
    private static final int ARGINDEX_38_TAG_ALIGNMENT = 0;
    private static final int ARGINDEX_38_SCOPE = 1;
    private static final int ARGINDEX_38_NAME = 2;
    private static final int ARGINDEX_38_FILE = 3;
    private static final int ARGINDEX_38_LINE = 4;
    private static final int ARGINDEX_38_TYPE = 5;
    private static final int ARGINDEX_38_ARG = 6;
    private static final int ARGINDEX_38_FLAGS = 7;
    private static final int OFFSET_INDICATOR = 8;
    private static final int ALIGNMENT_INDICATOR = 2;
    private static final long DW_TAG_LOCAL_VARIABLE_LINE_MASK = 0xFFFFFFL;
    private static final long DW_TAG_LOCAL_VARIABLE_ARG_MASK = -16777216L;
    private static final long DW_TAG_LOCAL_VARIABLE_ARG_SHIFT = 24L;
    private static final int ARGINDEX_32_SCOPE = 1;
    private static final int ARGINDEX_32_NAME = 2;
    private static final int ARGINDEX_32_FILE = 3;
    private static final int ARGINDEX_32_LINEARG = 4;
    private static final int ARGINDEX_32_TYPE = 5;
    private static final int ARGINDEX_32_FLAGS = 6;

    private MDLocalVariable(long line, long arg, long flags) {
        super(line);
        this.arg = arg;
        this.flags = flags;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public long getArg() {
        return this.arg;
    }

    public long getFlags() {
        return this.flags;
    }

    public static MDLocalVariable create38(long[] args, MetadataValueList md) {
        int argOffset = args.length > 8 && (args[0] & 2L) == 0L ? 1 : 0;
        long line = args[4 + argOffset];
        long arg = args[6 + argOffset];
        long flags = args[7 + argOffset];
        MDLocalVariable localVariable = new MDLocalVariable(line, arg, flags);
        localVariable.setScope(md.getNullable(args[1 + argOffset], localVariable));
        localVariable.setName(md.getNullable(args[2 + argOffset], localVariable));
        localVariable.setFile(md.getNullable(args[3 + argOffset], localVariable));
        localVariable.setType(md.getNullable(args[5 + argOffset], localVariable));
        return localVariable;
    }

    public static MDLocalVariable create32(long[] args, Metadata md) {
        long lineAndArg = ParseUtil.asInt(args, 4, md);
        long line = lineAndArg & 0xFFFFFFL;
        long arg = (lineAndArg & 0xFFFFFFFFFF000000L) >> 24;
        long flags = ParseUtil.asInt(args, 6, md);
        MDLocalVariable localVariable = new MDLocalVariable(line, arg, flags);
        localVariable.setName(ParseUtil.resolveReference(args, 2, localVariable, md));
        localVariable.setScope(ParseUtil.resolveReference(args, 1, localVariable, md));
        localVariable.setFile(ParseUtil.resolveReference(args, 3, localVariable, md));
        localVariable.setType(ParseUtil.resolveReference(args, 5, localVariable, md));
        return localVariable;
    }
}

