/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories;

import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.llvm.parser.factories.BasicAarch64PlatformCapability;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMNativeSyscallNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMSyscallExitNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.darwin.DarwinSyscall;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.aarch64.darwin.LLVMDarwinAarch64VaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.aarch64.darwin.LLVMDarwinAarch64VaListStorageFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVAListNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListStorage;
import com.oracle.truffle.llvm.runtime.pointer.LLVMMaybeVaPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;

final class DarwinAArch64PlatformCapability
extends BasicAarch64PlatformCapability<DarwinSyscall> {
    public static final int RTLD_GLOBAL_DARWIN = 8;
    public static final int RTLD_FIRST_DARWIN = 100;
    public static final long RTLD_DEFAULT_DARWIN = -2L;

    DarwinAArch64PlatformCapability(boolean loadCxxLibraries) {
        super(DarwinSyscall.class, loadCxxLibraries);
    }

    @Override
    public boolean isGlobalDLOpenFlagSet(int flag) {
        return (flag & 8) == 8;
    }

    @Override
    public boolean isFirstDLOpenFlagSet(int flag) {
        return (flag & 0x64) == 100;
    }

    @Override
    public boolean isDefaultDLSymFlagSet(long flag) {
        return flag == -2L;
    }

    @Override
    protected LLVMSyscallOperationNode createSyscallNode(DarwinSyscall syscall) {
        switch (syscall) {
            case SYS_exit: {
                return new LLVMSyscallExitNode();
            }
        }
        return new LLVMNativeSyscallNode(syscall);
    }

    @Override
    public Object createVAListStorage(LLVMVAListNode allocaNode, LLVMPointer vaListStackPtr, Type vaListType) {
        return LLVMMaybeVaPointer.createWithAlloca(vaListStackPtr, allocaNode);
    }

    @Override
    public Object createActualVAListStorage() {
        return new LLVMDarwinAarch64VaListStorage();
    }

    @Override
    public Type getGlobalVAListType(Type type) {
        return LLVMDarwinAarch64VaListStorage.VA_LIST_TYPE.equals(type) ? LLVMDarwinAarch64VaListStorage.VA_LIST_TYPE : null;
    }

    @Override
    public LLVMVaListStorage.VAListPointerWrapperFactory createNativeVAListWrapper(boolean cached) {
        return cached ? LLVMDarwinAarch64VaListStorageFactory.Aarch64VAListPointerWrapperFactoryNodeGen.create() : LLVMDarwinAarch64VaListStorageFactory.Aarch64VAListPointerWrapperFactoryNodeGen.getUncached();
    }

    @Override
    public InternalResource.OS getOS() {
        return InternalResource.OS.DARWIN;
    }

    @Override
    public int getDoubleLongSize() {
        return 128;
    }
}

