/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm;

import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import java.util.ArrayList;
import java.util.Base64;

final class CXXDemangler {
    private static final String NAMESPACE_PREFIX = "_ZN";
    private static final int NAMESPACE_PREFIX_LEN = "_ZN".length();
    private static final String SULONG_NAMESPACE_PREFIX = "___sulong_import_";
    private static final String SULONG_BASE64_NAMESPACE_SUFFIX = "base64";
    private static final String SULONG_BASE64_NAMESPACE = "___sulong_import_base64";
    private int idx;
    private final String name;

    private CXXDemangler(String name) {
        if (!name.startsWith(NAMESPACE_PREFIX)) {
            throw new LLVMLinkerException("Not a mangled namespace: " + name);
        }
        this.idx = NAMESPACE_PREFIX_LEN;
        this.name = name;
    }

    private int parseNumber() {
        int startIdx = this.idx;
        int libnameLength = 0;
        while (this.idx < this.name.length()) {
            char c = this.name.charAt(this.idx);
            if (c >= '0' && c <= '9') {
                int d = c - 48;
                libnameLength = libnameLength * 10 + d;
                ++this.idx;
                continue;
            }
            return libnameLength;
        }
        throw new LLVMLinkerException(String.format("Premature end of name string: %s (%d)", this.name, startIdx));
    }

    private ArrayList<String> decode() {
        ArrayList<String> namespaces = new ArrayList<String>();
        while (this.idx < this.name.length()) {
            int length = this.parseNumber();
            if (length == 0) {
                namespaces.add(this.name.substring(this.idx));
                return namespaces;
            }
            int newIdx = this.idx + length;
            if (newIdx >= this.name.length()) {
                throw new LLVMLinkerException(String.format("Premature end of name string: %s (%d)", this.name, this.idx));
            }
            namespaces.add(this.name.substring(this.idx, newIdx));
            this.idx = newIdx;
        }
        throw new LLVMLinkerException(String.format("Unterminated name %s (%d)", this.name, this.idx));
    }

    static boolean isRenamedNamespaceSymbol(String name) {
        return name.startsWith(NAMESPACE_PREFIX) && name.contains(SULONG_NAMESPACE_PREFIX);
    }

    static ArrayList<String> decodeNamespace(String name) {
        return new CXXDemangler(name).decode();
    }

    static String getAndRemoveLibraryName(ArrayList<String> namespaces) {
        int numNamespaces = namespaces.size() - 1;
        for (int i = 0; i < numNamespaces; ++i) {
            String namespace = namespaces.get(i);
            if (!namespace.startsWith(SULONG_NAMESPACE_PREFIX)) continue;
            int libIdx = i + 1;
            if (libIdx >= numNamespaces) {
                throw new LLVMLinkerException(String.format("No library name to decode: ", String.join((CharSequence)"::", namespaces)));
            }
            String rawLibname = namespaces.get(libIdx);
            namespaces.set(i, null);
            namespaces.set(libIdx, null);
            if (namespace.equals(SULONG_NAMESPACE_PREFIX)) {
                return rawLibname;
            }
            if (!namespace.equals(SULONG_BASE64_NAMESPACE)) continue;
            return new String(CXXDemangler.decodeBase64(rawLibname));
        }
        return null;
    }

    static byte[] decodeBase64(CharSequence charSequence) {
        byte[] result = new byte[charSequence.length()];
        for (int i = 0; i < result.length; ++i) {
            char ch = charSequence.charAt(i);
            assert (ch >= '\u0000' && ch <= '\u007f');
            result[i] = (byte)ch;
        }
        return Base64.getDecoder().decode(result);
    }

    static String encodeNamespace(ArrayList<String> namespaces) {
        StringBuilder sb = new StringBuilder();
        sb.append(NAMESPACE_PREFIX);
        int numNamespaces = namespaces.size() - 1;
        for (int i = 0; i < numNamespaces; ++i) {
            String namespace = namespaces.get(i);
            if (namespace == null) continue;
            sb.append(namespace.length());
            sb.append(namespace);
        }
        sb.append(namespaces.get(numNamespaces));
        return sb.toString();
    }
}

