/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.ManagedMemMoveHelperNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.NativeProfiledMemMove;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@GenerateUncached
public abstract class NativeProfiledMemMoveToNative
extends LLVMNode {
    protected static final long MAX_JAVA_LEN = 256L;

    public abstract void executeNative(LLVMNativePointer var1, Object var2, long var3);

    @Specialization(limit="4", guards={"helper.guard(target, source)"})
    protected void doNativeManaged(LLVMNativePointer target, LLVMManagedPointer source, long length, @Cached(value="create(target, source)") ManagedMemMoveHelperNode helper, @Cached ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode) {
        NativeProfiledMemMove.copyForward(target, source, length, helper, unitSizeNode);
    }

    @Specialization(guards={"length <= MAX_JAVA_LEN"})
    protected void doInJava(LLVMNativePointer target, Object source, long length, @Cached LLVMToNativeNode convertSource) {
        LLVMMemory memory = this.getLanguage().getLLVMMemory();
        LLVMNativePointer s = convertSource.executeWithTarget(source);
        long targetPointer = target.asNative();
        long sourcePointer = s.asNative();
        if (CompilerDirectives.injectBranchProbability((double)0.75, (length > 0L && sourcePointer != targetPointer ? (byte)1 : 0) != 0)) {
            if (CompilerDirectives.injectBranchProbability((double)0.75, (Long.compareUnsigned(targetPointer - sourcePointer, length) >= 0 ? (byte)1 : 0) != 0)) {
                this.copyForward(memory, targetPointer, sourcePointer, length);
            } else {
                this.copyBackward(memory, targetPointer, sourcePointer, length);
            }
        }
    }

    @Specialization(replaces={"doInJava", "doNativeManaged"})
    protected void doNative(LLVMNativePointer target, Object source, long length, @Cached LLVMToNativeNode convertSource) {
        this.getLanguage().getLLVMMemory().copyMemory(this, convertSource.executeWithTarget(source).asNative(), target.asNative(), length);
    }

    private void copyForward(LLVMMemory memory, long target, long source, long length) {
        long targetPointer = target;
        long sourcePointer = source;
        long i64ValuesToWrite = length >> 3;
        long i = 0L;
        while (CompilerDirectives.injectBranchProbability((double)0.75, (i < i64ValuesToWrite ? (byte)1 : 0) != 0)) {
            long v64 = memory.getI64((Node)this, sourcePointer);
            memory.putI64((Node)this, targetPointer, v64);
            targetPointer += 8L;
            sourcePointer += 8L;
            ++i;
        }
        long i8ValuesToWrite = length & 7L;
        long i2 = 0L;
        while (CompilerDirectives.injectBranchProbability((double)0.75, (i2 < i8ValuesToWrite ? (byte)1 : 0) != 0)) {
            byte value = memory.getI8((Node)this, sourcePointer);
            memory.putI8((Node)this, targetPointer, value);
            ++targetPointer;
            ++sourcePointer;
            ++i2;
        }
    }

    private void copyBackward(LLVMMemory memory, long target, long source, long length) {
        long targetPointer = target + length;
        long sourcePointer = source + length;
        long i64ValuesToWrite = length >> 3;
        long i = 0L;
        while (CompilerDirectives.injectBranchProbability((double)0.75, (i < i64ValuesToWrite ? (byte)1 : 0) != 0)) {
            long v64 = memory.getI64((Node)this, sourcePointer -= 8L);
            memory.putI64((Node)this, targetPointer -= 8L, v64);
            ++i;
        }
        long i8ValuesToWrite = length & 7L;
        long i2 = 0L;
        while (CompilerDirectives.injectBranchProbability((double)0.75, (i2 < i8ValuesToWrite ? (byte)1 : 0) != 0)) {
            byte value = memory.getI8((Node)this, --sourcePointer);
            memory.putI8((Node)this, --targetPointer, value);
            ++i2;
        }
    }
}

