/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMArgNode
extends LLVMExpressionNode {
    private final int index;

    protected LLVMArgNode(int index) {
        this.index = index;
    }

    @Override
    public String toString() {
        return this.getShortString("index");
    }

    @Specialization(guards={"isPointer(frame)"})
    protected Object doPointer(VirtualFrame frame) {
        return LLVMPointer.cast(frame.getArguments()[this.index]).copy();
    }

    public boolean isPointer(VirtualFrame frame) {
        return LLVMPointer.isInstance(frame.getArguments()[this.index]);
    }

    @Specialization(guards={"!isPointer(frame)"})
    protected Object doObject(VirtualFrame frame) {
        return frame.getArguments()[this.index];
    }
}

