/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.export;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMOffsetLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMForeignReadNode.class)
public final class LLVMForeignReadNodeGen
extends LLVMForeignReadNode
implements GenerateAOT.Provider {
    static final InlineSupport.ReferenceField<ValueData> VALUE_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"value_cache", ValueData.class);
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final LLVMInteropType.ValueKind[] VALUE_KIND_VALUES = (LLVMInteropType.ValueKind[])DSLSupport.lookupEnumConstants(LLVMInteropType.ValueKind.class);
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    @InlineSupport.UnsafeAccessedField
    private ValueData value_cache;

    private LLVMForeignReadNodeGen() {
    }

    @Override
    @ExplodeLoop
    public Object execute(LLVMPointer arg0Value, LLVMInteropType arg1Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }
        if ((state_0 & 6) != 0) {
            if ((state_0 & 2) != 0 && arg1Value instanceof LLVMInteropType.Structured) {
                LLVMInteropType.Structured arg1Value_ = (LLVMInteropType.Structured)arg1Value;
                return LLVMForeignReadNode.doStructured(arg0Value, arg1Value_);
            }
            if ((state_0 & 4) != 0 && arg1Value instanceof LLVMInteropType.Value) {
                LLVMInteropType.Value arg1Value_ = (LLVMInteropType.Value)arg1Value;
                ValueData s1_ = this.value_cache;
                while (s1_ != null) {
                    if (arg1Value_.kind == LLVMForeignReadNodeGen.decodeValueKind((s1_.value_state_0_ >>> 0) - 2)) {
                        return LLVMForeignReadNode.doValue(arg0Value, arg1Value_, LLVMForeignReadNodeGen.decodeValueKind((s1_.value_state_0_ >>> 0) - 2), s1_.load_, s1_.dataEscape_);
                    }
                    s1_ = s1_.next_;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private Object executeAndSpecialize(LLVMPointer arg0Value, LLVMInteropType arg1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg1Value instanceof LLVMInteropType.Structured) {
            LLVMInteropType.Structured arg1Value_ = (LLVMInteropType.Structured)arg1Value;
            this.state_0_ = state_0 |= 2;
            return LLVMForeignReadNode.doStructured(arg0Value, arg1Value_);
        }
        if (arg1Value instanceof LLVMInteropType.Value) {
            ValueData s1_;
            LLVMInteropType.Value arg1Value_;
            block6: {
                ValueData s1_original;
                arg1Value_ = (LLVMInteropType.Value)arg1Value;
                do {
                    int count1_ = 0;
                    s1_original = s1_ = (ValueData)((Object)VALUE_CACHE_UPDATER.getVolatile((Node)this));
                    while (s1_ != null && arg1Value_.kind != LLVMForeignReadNodeGen.decodeValueKind((s1_.value_state_0_ >>> 0) - 2)) {
                        ++count1_;
                        s1_ = s1_.next_;
                    }
                    if (s1_ != null || count1_ >= LLVMForeignReadNode.VALUE_KIND_COUNT) break block6;
                    s1_ = (ValueData)this.insert(new ValueData(s1_original));
                    s1_.value_state_0_ |= LLVMForeignReadNodeGen.encodeValueKind(arg1Value_.kind) + 2 << 0;
                    s1_.load_ = (LLVMOffsetLoadNode)s1_.insert(LLVMOffsetLoadNode.create(LLVMForeignReadNodeGen.decodeValueKind((s1_.value_state_0_ >>> 0) - 2)));
                    s1_.dataEscape_ = (LLVMDataEscapeNode)s1_.insert(LLVMDataEscapeNode.create(LLVMForeignReadNodeGen.decodeValueKind((int)((s1_.value_state_0_ >>> 0) - 2)).foreignToLLVMType));
                } while (!VALUE_CACHE_UPDATER.compareAndSet((Node)this, (Object)s1_original, (Object)s1_));
                this.state_0_ = state_0 |= 4;
            }
            if (s1_ != null) {
                return LLVMForeignReadNode.doValue(arg0Value, arg1Value_, LLVMForeignReadNodeGen.decodeValueKind((s1_.value_state_0_ >>> 0) - 2), s1_.load_, s1_.dataEscape_);
            }
        }
        throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @CompilerDirectives.TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
        return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value});
    }

    @NeverDefault
    public static LLVMForeignReadNode create() {
        return new LLVMForeignReadNodeGen();
    }

    @NeverDefault
    public static LLVMForeignReadNode getUncached() {
        return UNCACHED;
    }

    private static LLVMInteropType.ValueKind decodeValueKind(int state) {
        if (state >= 0) {
            return VALUE_KIND_VALUES[state];
        }
        return null;
    }

    private static int encodeValueKind(LLVMInteropType.ValueKind e) {
        if (e != null) {
            return e.ordinal();
        }
        return -1;
    }

    @GeneratedBy(value=LLVMForeignReadNode.class)
    @DenyReplace
    private static final class ValueData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        ValueData next_;
        @CompilerDirectives.CompilationFinal
        private int value_state_0_;
        @Node.Child
        LLVMOffsetLoadNode load_;
        @Node.Child
        LLVMDataEscapeNode dataEscape_;

        ValueData(ValueData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=LLVMForeignReadNode.class)
    @DenyReplace
    private static final class Uncached
    extends LLVMForeignReadNode
    implements UnadoptableNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(LLVMPointer arg0Value, LLVMInteropType arg1Value) {
            if (arg1Value instanceof LLVMInteropType.Structured) {
                LLVMInteropType.Structured arg1Value_ = (LLVMInteropType.Structured)arg1Value;
                return LLVMForeignReadNode.doStructured(arg0Value, arg1Value_);
            }
            if (arg1Value instanceof LLVMInteropType.Value) {
                LLVMInteropType.Value arg1Value_ = (LLVMInteropType.Value)arg1Value;
                return LLVMForeignReadNode.doValue(arg0Value, arg1Value_, arg1Value_.kind, LLVMOffsetLoadNode.getUncached(arg1Value_.kind), LLVMDataEscapeNode.getUncached(arg1Value_.kind.foreignToLLVMType));
            }
            throw LLVMForeignReadNodeGen.newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
        }
    }
}

