/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

@NodeChild(value="condition", type=LLVMExpressionNode.class)
public abstract class DebugExprTernaryNode
extends LLVMExpressionNode {
    @Node.Child
    private LLVMExpressionNode thenNode;
    @Node.Child
    private LLVMExpressionNode elseNode;
    private final ConditionProfile conditionProfile;

    public abstract Object executeWithTarget(VirtualFrame var1, Object var2);

    public DebugExprTernaryNode(LLVMExpressionNode thenNode, LLVMExpressionNode elseNode) {
        this.thenNode = thenNode;
        this.elseNode = elseNode;
        this.conditionProfile = ConditionProfile.create();
    }

    @Specialization
    Object doTernary(VirtualFrame frame, boolean condition) {
        if (this.conditionProfile.profile(condition)) {
            return this.thenNode.executeGeneric(frame);
        }
        return this.elseNode.executeGeneric(frame);
    }

    @Specialization
    Object doTernary(VirtualFrame frame, int condition) {
        if (this.conditionProfile.profile(condition != 0)) {
            return this.thenNode.executeGeneric(frame);
        }
        return this.elseNode.executeGeneric(frame);
    }

    @Specialization
    Object doTernary(VirtualFrame frame, long condition) {
        if (this.conditionProfile.profile(condition != 0L)) {
            return this.thenNode.executeGeneric(frame);
        }
        return this.elseNode.executeGeneric(frame);
    }

    @Fallback
    Object doError(Object condition) {
        throw DebugExprException.typeError(this, condition);
    }
}

