/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CompareInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.CompareOperator;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class CompareConstant
extends AbstractConstant {
    private final CompareOperator operator;
    private Constant lhs;
    private Constant rhs;

    private CompareConstant(Type type, CompareOperator operator) {
        super(type);
        this.operator = operator;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.lhs == original) {
            this.lhs = (Constant)replacement;
        }
        if (this.rhs == original) {
            this.rhs = (Constant)replacement;
        }
    }

    public static CompareConstant fromSymbols(SymbolTable symbols, Type type, int opcode, int lhs, int rhs) {
        CompareConstant constant = new CompareConstant(type, CompareInstruction.decodeCompareOperator(opcode));
        constant.lhs = symbols.getForwardReferenced(lhs, constant);
        constant.rhs = symbols.getForwardReferenced(rhs, constant);
        return constant;
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        return CommonNodeFactory.createComparison(this.operator, this.lhs.getType(), this.lhs.createNode(runtime, dataLayout, stackFactory), this.rhs.createNode(runtime, dataLayout, stackFactory));
    }
}

