/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata.debuginfo;

import com.oracle.truffle.llvm.parser.metadata.MDAttachment;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDCompileUnit;
import com.oracle.truffle.llvm.parser.metadata.MDFile;
import com.oracle.truffle.llvm.parser.metadata.MDGlobalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDKind;
import com.oracle.truffle.llvm.parser.metadata.MDNamedNode;
import com.oracle.truffle.llvm.parser.metadata.MDNode;
import com.oracle.truffle.llvm.parser.metadata.MDString;
import com.oracle.truffle.llvm.parser.metadata.MDSubprogram;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataAttachmentHolder;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.MDSymbolExtractor;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalValueSymbol;

final class MDUpgrade
implements MetadataVisitor {
    private final MDKind dbgKind;
    private MDCompileUnit currentCU;

    static void perform(MetadataValueList metadata) {
        MDNamedNode cuNode = metadata.getNamedNode("llvm.dbg.cu");
        if (cuNode == null) {
            return;
        }
        MDKind dbgKind = metadata.findKind("dbg");
        cuNode.accept(new MDUpgrade(dbgKind));
    }

    private MDUpgrade(MDKind dbgKind) {
        this.dbgKind = dbgKind;
        this.currentCU = null;
    }

    @Override
    public void visit(MDCompileUnit md) {
        this.currentCU = md;
        if (md.getFile() instanceof MDString) {
            MDFile fileRef = MDFile.create(md.getFile(), md.getDirectory());
            md.replace(md.getFile(), fileRef);
        }
        md.getSubprograms().accept(this);
        md.getGlobalVariables().accept(this);
        this.currentCU = null;
    }

    @Override
    public void visit(MDNode md) {
        for (MDBaseNode elt : md) {
            elt.accept(this);
        }
    }

    @Override
    public void visit(MDNamedNode md) {
        for (MDBaseNode elt : md) {
            elt.accept(this);
        }
    }

    @Override
    public void visit(MDSubprogram md) {
        SymbolImpl valueSymbol = MDSymbolExtractor.getSymbol(md.getFunction());
        if (valueSymbol instanceof FunctionDefinition) {
            FunctionDefinition function = (FunctionDefinition)valueSymbol;
            this.attachSymbol(function, md);
        }
        if (this.currentCU != null && md.getCompileUnit() == MDVoidNode.INSTANCE) {
            md.setCompileUnit(this.currentCU);
        }
    }

    @Override
    public void visit(MDGlobalVariable mdGlobal) {
        SymbolImpl symbol = MDSymbolExtractor.getSymbol(mdGlobal.getVariable());
        if (symbol instanceof GlobalValueSymbol) {
            GlobalValueSymbol global = (GlobalValueSymbol)symbol;
            this.attachSymbol(global, mdGlobal);
        }
        if (this.currentCU != null) {
            mdGlobal.setCompileUnit(this.currentCU);
        }
    }

    private void attachSymbol(MetadataAttachmentHolder container, MDBaseNode ref) {
        if (!container.hasAttachedMetadata() || container.getMetadataAttachment("dbg") == null) {
            MDAttachment dbg = MDAttachment.create(this.dbgKind, ref);
            container.attachMetadata(dbg);
        }
    }
}

