/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;

public final class MDArgList
implements MDBaseNode {
    private final MDBaseNode[] args;

    public MDArgList(int argc) {
        this.args = new MDBaseNode[argc];
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        assert (this.args != null);
        for (int i = 0; i < this.args.length; ++i) {
            MDBaseNode arg = this.args[i];
            if (oldValue != arg) continue;
            this.args[i] = newValue;
            break;
        }
    }

    public void setArg(MDBaseNode arg, int index) {
        assert (index < this.args.length);
        this.args[index] = arg;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public static MDArgList create(long[] args, MetadataValueList md) {
        MDArgList argList = new MDArgList(args.length);
        for (int i = 0; i < args.length; ++i) {
            argList.setArg(md.getNullable(args[i], argList), i);
        }
        return argList;
    }
}

